/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.appear.PortManager;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentListener;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CircuitPins {
    private final PortManager appearanceManager;
    private final MyComponentListener myComponentListener;
    private final Set<Instance> pins;

    CircuitPins(PortManager appearanceManager) {
        this.appearanceManager = appearanceManager;
        this.myComponentListener = new MyComponentListener();
        this.pins = new HashSet<Instance>();
    }

    public Collection<Instance> getPins() {
        return new ArrayList<Instance>(this.pins);
    }

    public void transactionCompleted(ReplacementMap repl) {
        Instance in;
        HashSet<Instance> adds = new HashSet<Instance>();
        HashSet<Instance> removes = new HashSet<Instance>();
        HashMap<Instance, Instance> replaces = new HashMap<Instance, Instance>();
        for (Component component : repl.getAdditions()) {
            boolean added;
            if (!(component.getFactory() instanceof Pin) || !(added = this.pins.add(in = Instance.getInstanceFor(component)))) continue;
            component.addComponentListener(this.myComponentListener);
            in.getAttributeSet().addAttributeListener(this.myComponentListener);
            adds.add(in);
        }
        for (Component component : repl.getRemovals()) {
            boolean removed;
            if (!(component.getFactory() instanceof Pin) || !(removed = this.pins.remove(in = Instance.getInstanceFor(component)))) continue;
            component.removeComponentListener(this.myComponentListener);
            in.getAttributeSet().removeAttributeListener(this.myComponentListener);
            Collection<Component> rs = repl.getReplacementsFor(component);
            if (rs.isEmpty()) {
                removes.add(in);
                continue;
            }
            Component r = rs.iterator().next();
            Instance rIn = Instance.getInstanceFor(r);
            adds.remove(rIn);
            replaces.put(in, rIn);
        }
        this.appearanceManager.updatePorts(adds, removes, replaces, this.getPins());
    }

    private class MyComponentListener
    implements ComponentListener,
    AttributeListener {
        private MyComponentListener() {
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            Attribute<?> attr = e.getAttribute();
            if (attr == StdAttr.FACING || attr == StdAttr.LABEL || attr == Pin.ATTR_TYPE) {
                CircuitPins.this.appearanceManager.updatePorts();
            }
        }

        @Override
        public void endChanged(ComponentEvent e) {
            CircuitPins.this.appearanceManager.updatePorts();
        }
    }
}

