/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.WireBundle;
import java.util.HashSet;

class WireThread {
    private WireThread representative;
    private HashSet<BundlePosition> tempBundlePositions = new HashSet();
    public int steps;
    public WireBundle[] bundle;
    public int[] position;

    WireThread() {
        this.representative = this;
    }

    void addBundlePosition(int pos, WireBundle b) {
        this.tempBundlePositions.add(new BundlePosition(pos, b));
    }

    void finishConstructing() {
        if (this.tempBundlePositions == null) {
            return;
        }
        this.steps = this.tempBundlePositions.size();
        this.bundle = new WireBundle[this.steps];
        this.position = new int[this.steps];
        int i = 0;
        for (BundlePosition bp : this.tempBundlePositions) {
            this.bundle[i] = bp.b;
            this.position[i] = bp.pos;
            ++i;
        }
        this.tempBundlePositions = null;
    }

    WireThread getRepresentative() {
        WireThread ret = this;
        if (ret.representative != ret) {
            while (ret.representative != (ret = ret.representative)) {
            }
            this.representative = ret;
        }
        return ret;
    }

    void unite(WireThread other) {
        WireThread them;
        WireThread us = this.getRepresentative();
        if (us != (them = other.getRepresentative())) {
            us.representative = them;
        }
    }

    private static class BundlePosition {
        int pos;
        WireBundle b;

        BundlePosition(int pos, WireBundle b) {
            this.pos = pos;
            this.b = b;
        }
    }
}

