/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class WireRepair
extends CircuitTransaction {
    private final Circuit circuit;

    public WireRepair(Circuit circuit) {
        this.circuit = circuit;
    }

    private void doMerges(CircuitMutator mutator) {
        MergeSets sets = new MergeSets();
        for (Location loc : this.circuit.wires.points.getAllLocations()) {
            Wire w1;
            Collection<? extends Component> at = this.circuit.getComponents(loc);
            if (at.size() != 2) continue;
            Iterator<? extends Component> atit = at.iterator();
            Component at0 = atit.next();
            Component at1 = atit.next();
            if (!(at0 instanceof Wire)) continue;
            Wire w0 = (Wire)at0;
            if (!(at1 instanceof Wire) || !w0.isParallel(w1 = (Wire)at1)) continue;
            sets.merge(w0, w1);
        }
        ReplacementMap repl = new ReplacementMap();
        for (ArrayList<Wire> mergeSet : sets.getMergeSets()) {
            if (mergeSet.size() <= 1) continue;
            ArrayList<Location> locs = new ArrayList<Location>(2 * mergeSet.size());
            for (Wire w : mergeSet) {
                locs.add(w.getEnd0());
                locs.add(w.getEnd1());
            }
            Collections.sort(locs);
            Location e0 = (Location)locs.get(0);
            Location e1 = (Location)locs.get(locs.size() - 1);
            Wire wnew = Wire.create(e0, e1);
            Set<Wire> wset = Collections.singleton(wnew);
            for (Wire w : mergeSet) {
                if (w.equals(wnew)) continue;
                repl.put(w, wset);
            }
        }
        mutator.replace(this.circuit, repl);
    }

    private void doMergeSet(ArrayList<Wire> mergeSet, ReplacementMap replacements, Set<Location> allLocs) {
        TreeSet<Location> ends = new TreeSet<Location>();
        for (Wire w : mergeSet) {
            ends.add(w.getEnd0());
            ends.add(w.getEnd1());
        }
        Wire whole = Wire.create((Location)ends.first(), (Location)ends.last());
        TreeSet<Location> mids = new TreeSet<Location>();
        mids.add(whole.getEnd0());
        mids.add(whole.getEnd1());
        block1: for (Location loc : whole) {
            if (!allLocs.contains(loc)) continue;
            for (Component component : this.circuit.getComponents(loc)) {
                if (mergeSet.contains(component)) continue;
                mids.add(loc);
                continue block1;
            }
        }
        ArrayList<Wire> mergeResult = new ArrayList<Wire>();
        if (mids.size() == 2) {
            mergeResult.add(whole);
        } else {
            Location e0 = null;
            for (Location location : mids) {
                if (e0 != null) {
                    mergeResult.add(Wire.create(e0, location));
                }
                e0 = location;
            }
        }
        for (Wire w : mergeSet) {
            ArrayList<Wire> arrayList = new ArrayList<Wire>(2);
            for (Wire w2 : mergeResult) {
                if (!w2.overlaps(w, false)) continue;
                arrayList.add(w2);
            }
            replacements.put(w, arrayList);
        }
    }

    private void doOverlaps(CircuitMutator mutator) {
        HashMap<Location, ArrayList> wirePoints = new HashMap<Location, ArrayList>();
        for (Wire wire : this.circuit.getWires()) {
            for (Location loc : wire) {
                ArrayList locWires = wirePoints.computeIfAbsent(loc, k -> new ArrayList(3));
                locWires.add(wire);
            }
        }
        MergeSets mergeSets = new MergeSets();
        for (ArrayList locWires : wirePoints.values()) {
            if (locWires.size() <= 1) continue;
            int n = locWires.size();
            for (int i = 0; i < n; ++i) {
                Wire w0 = (Wire)locWires.get(i);
                for (int j = i + 1; j < n; ++j) {
                    Wire w1 = (Wire)locWires.get(j);
                    if (!w0.overlaps(w1, false)) continue;
                    mergeSets.merge(w0, w1);
                }
            }
        }
        ReplacementMap replacementMap = new ReplacementMap();
        Set<Location> allLocs = this.circuit.wires.points.getAllLocations();
        for (ArrayList<Wire> mergeSet : mergeSets.getMergeSets()) {
            if (mergeSet.size() <= 1) continue;
            this.doMergeSet(mergeSet, replacementMap, allLocs);
        }
        mutator.replace(this.circuit, replacementMap);
    }

    private void doSplits(CircuitMutator mutator) {
        Set<Location> allLocs = this.circuit.wires.points.getAllLocations();
        ReplacementMap repl = new ReplacementMap();
        for (Wire w : this.circuit.getWires()) {
            Location w0 = w.getEnd0();
            Location w1 = w.getEnd1();
            ArrayList<Location> splits = null;
            for (Location loc : allLocs) {
                if (!w.contains(loc) || loc.equals(w0) || loc.equals(w1)) continue;
                if (splits == null) {
                    splits = new ArrayList<Location>();
                }
                splits.add(loc);
            }
            if (splits == null) continue;
            splits.add(w1);
            Collections.sort(splits);
            Location e0 = w0;
            ArrayList<Wire> subs = new ArrayList<Wire>(splits.size());
            for (Location e1 : splits) {
                subs.add(Wire.create(e0, e1));
                e0 = e1;
            }
            repl.put(w, subs);
        }
        mutator.replace(this.circuit, repl);
    }

    @Override
    protected Map<Circuit, Integer> getAccessedCircuits() {
        return Collections.singletonMap(this.circuit, READ_WRITE);
    }

    @Override
    protected void run(CircuitMutator mutator) {
        this.doMerges(mutator);
        this.doOverlaps(mutator);
        this.doSplits(mutator);
    }

    private static class MergeSets {
        private final HashMap<Wire, ArrayList<Wire>> map = new HashMap();

        private MergeSets() {
        }

        Collection<ArrayList<Wire>> getMergeSets() {
            IdentityHashMap<ArrayList<Wire>, Boolean> lists = new IdentityHashMap<ArrayList<Wire>, Boolean>();
            for (ArrayList<Wire> list : this.map.values()) {
                lists.put(list, Boolean.TRUE);
            }
            return lists.keySet();
        }

        void merge(Wire a, Wire b) {
            ArrayList<Wire> set0 = this.map.get(a);
            ArrayList<Wire> set1 = this.map.get(b);
            if (set0 == null && set1 == null) {
                set0 = new ArrayList(2);
                set0.add(a);
                set0.add(b);
                this.map.put(a, set0);
                this.map.put(b, set0);
            } else if (set0 == null && set1 != null) {
                set1.add(a);
                this.map.put(a, set1);
            } else if (set0 != null && set1 == null) {
                set0.add(b);
                this.map.put(b, set0);
            } else if (set0 != set1) {
                if (set0.size() > set1.size()) {
                    ArrayList<Wire> temp = set0;
                    set0 = set1;
                    set1 = temp;
                }
                set1.addAll(set0);
                for (Wire w : set0) {
                    this.map.put(w, set1);
                }
            }
        }
    }
}

