/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.data.Location;
import java.util.Iterator;

class WireIterator
implements Iterator<Location> {
    private int curX;
    private int curY;
    private int destX;
    private int destY;
    private final int deltaX;
    private final int deltaY;
    private boolean destReturned;

    public WireIterator(Location e0, Location e1) {
        int offY;
        this.curX = e0.getX();
        this.curY = e0.getY();
        this.destX = e1.getX();
        this.destY = e1.getY();
        this.destReturned = false;
        this.deltaX = this.curX < this.destX ? 10 : (this.curX > this.destX ? -10 : 0);
        this.deltaY = this.curY < this.destY ? 10 : (this.curY > this.destY ? -10 : 0);
        int offX = (this.destX - this.curX) % 10;
        if (offX != 0) {
            this.destX = this.curX + this.deltaX * ((this.destX - this.curX) / 10);
        }
        if ((offY = (this.destY - this.curY) % 10) != 0) {
            this.destY = this.curY + this.deltaY * ((this.destY - this.curY) / 10);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.destReturned;
    }

    @Override
    public Location next() {
        Location ret = Location.create(this.curX, this.curY, true);
        this.destReturned |= this.curX == this.destX && this.curY == this.destY;
        this.curX += this.deltaX;
        this.curY += this.deltaY;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

