/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.SplitterParameters;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.gui.generic.ComboBox;
import com.cburch.logisim.instance.StdAttr;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SplitterAttributes
extends AbstractAttributeSet {
    public static final AttributeOption APPEAR_LEGACY = new AttributeOption("legacy", Strings.S.getter("splitterAppearanceLegacy"));
    public static final Attribute<Integer> ATTR_SPACING = Attributes.forIntegerRange("spacing", Strings.S.getter("splitterSpacing"), 1, 9);
    public static final AttributeOption APPEAR_LEFT = new AttributeOption("left", Strings.S.getter("splitterAppearanceLeft"));
    public static final AttributeOption APPEAR_RIGHT = new AttributeOption("right", Strings.S.getter("splitterAppearanceRight"));
    public static final AttributeOption APPEAR_CENTER = new AttributeOption("center", Strings.S.getter("splitterAppearanceCenter"));
    public static final Attribute<AttributeOption> ATTR_APPEARANCE = Attributes.forOption("appear", Strings.S.getter("splitterAppearanceAttr"), new AttributeOption[]{APPEAR_LEFT, APPEAR_RIGHT, APPEAR_CENTER, APPEAR_LEGACY});
    public static final Attribute<BitWidth> ATTR_WIDTH = Attributes.forBitWidth("incoming", Strings.S.getter("splitterBitWidthAttr"));
    public static final Attribute<Integer> ATTR_FANOUT = Attributes.forIntegerRange("fanout", Strings.S.getter("splitterFanOutAttr"), 1, 64);
    private static final List<Attribute<?>> INIT_ATTRIBUTES = Arrays.asList(StdAttr.FACING, ATTR_FANOUT, ATTR_WIDTH, ATTR_APPEARANCE, ATTR_SPACING);
    private static final String UNCHOSEN_VAL = "none";
    private ArrayList<Attribute<?>> attrs = new ArrayList(INIT_ATTRIBUTES);
    private SplitterParameters parameters;
    AttributeOption appear = APPEAR_LEFT;
    Direction facing = Direction.EAST;
    int spacing = 1;
    byte fanout = (byte)2;
    byte[] bitEnd = new byte[2];
    BitOutOption[] options = null;

    static byte[] computeDistribution(int fanout, int bits, int order) {
        byte[] ret = new byte[bits];
        if (order >= 0) {
            if (fanout >= bits) {
                for (int i = 0; i < bits; ++i) {
                    ret[i] = (byte)(i + 1);
                }
            } else {
                int threads_per_end = bits / fanout;
                int endsWithExtra = bits % fanout;
                int curEnd = -1;
                int leftInEnd = 0;
                for (int i = 0; i < bits; ++i) {
                    if (leftInEnd == 0) {
                        ++curEnd;
                        leftInEnd = threads_per_end;
                        if (endsWithExtra > 0) {
                            ++leftInEnd;
                            --endsWithExtra;
                        }
                    }
                    ret[i] = (byte)(1 + curEnd);
                    --leftInEnd;
                }
            }
        } else if (fanout >= bits) {
            for (int i = 0; i < bits; ++i) {
                ret[i] = (byte)(fanout - i);
            }
        } else {
            int threads_per_end = bits / fanout;
            int endsWithExtra = bits % fanout;
            int curEnd = -1;
            int leftInEnd = 0;
            for (int i = bits - 1; i >= 0; --i) {
                if (leftInEnd == 0) {
                    ++curEnd;
                    leftInEnd = threads_per_end;
                    if (endsWithExtra > 0) {
                        ++leftInEnd;
                        --endsWithExtra;
                    }
                }
                ret[i] = (byte)(1 + curEnd);
                --leftInEnd;
            }
        }
        return ret;
    }

    SplitterAttributes() {
        this.configureOptions();
        this.configureDefaults();
        this.parameters = new SplitterParameters(this);
    }

    public boolean isNoConnect(int index) {
        for (byte b : this.bitEnd) {
            if (b != index) continue;
            return false;
        }
        return true;
    }

    private void configureDefaults() {
        BitOutAttribute attr;
        int i;
        boolean changed;
        int offs = INIT_ATTRIBUTES.size();
        int curNum = this.attrs.size() - offs;
        byte[] dflt = SplitterAttributes.computeDistribution(this.fanout, this.bitEnd.length, 1);
        boolean bl = changed = curNum != this.bitEnd.length;
        while (curNum > this.bitEnd.length) {
            this.attrs.remove(offs + --curNum);
        }
        for (i = 0; i < curNum; ++i) {
            if (this.bitEnd[i] == dflt[i]) continue;
            attr = (BitOutAttribute)this.attrs.get(offs + i);
            this.bitEnd[i] = dflt[i];
            this.fireAttributeValueChanged(attr, Integer.valueOf(this.bitEnd[i]), null);
        }
        for (i = curNum; i < this.bitEnd.length; ++i) {
            attr = new BitOutAttribute(i, this.options);
            this.bitEnd[i] = dflt[i];
            this.attrs.add(attr);
        }
        if (changed) {
            this.fireAttributeListChanged();
        }
    }

    private void configureOptions() {
        this.options = new BitOutOption[this.fanout + 1];
        boolean isVertical = this.facing == Direction.EAST || this.facing == Direction.WEST;
        for (int i = -1; i < this.fanout; ++i) {
            this.options[i + 1] = new BitOutOption(i, isVertical, i == this.fanout - 1);
        }
        int offs = INIT_ATTRIBUTES.size();
        int curNum = this.attrs.size() - offs;
        for (int i = 0; i < curNum; ++i) {
            BitOutAttribute attr = (BitOutAttribute)this.attrs.get(offs + i);
            attr.options = this.options;
        }
    }

    @Override
    protected void copyInto(AbstractAttributeSet destObj) {
        SplitterAttributes dest = (SplitterAttributes)destObj;
        dest.parameters = this.parameters;
        dest.attrs = new ArrayList(this.attrs.size());
        dest.attrs.addAll(INIT_ATTRIBUTES);
        int n = this.attrs.size();
        for (int i = INIT_ATTRIBUTES.size(); i < n; ++i) {
            BitOutAttribute attr = (BitOutAttribute)this.attrs.get(i);
            dest.attrs.add(attr.createCopy());
        }
        dest.facing = this.facing;
        dest.fanout = this.fanout;
        dest.appear = this.appear;
        dest.spacing = this.spacing;
        dest.bitEnd = (byte[])this.bitEnd.clone();
        dest.options = this.options;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.attrs;
    }

    Attribute<?> getBitOutAttribute(int index) {
        return this.attrs.get(INIT_ATTRIBUTES.size() + index);
    }

    public SplitterParameters getParameters() {
        if (this.parameters == null) {
            this.parameters = new SplitterParameters(this);
        }
        return this.parameters;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == StdAttr.FACING) {
            return (V)this.facing;
        }
        if (attr == ATTR_FANOUT) {
            return (V)Integer.valueOf(this.fanout);
        }
        if (attr == ATTR_WIDTH) {
            return (V)BitWidth.create(this.bitEnd.length);
        }
        if (attr == ATTR_APPEARANCE) {
            return (V)this.appear;
        }
        if (attr == ATTR_SPACING) {
            return (V)Integer.valueOf(this.spacing);
        }
        if (attr instanceof BitOutAttribute) {
            BitOutAttribute bitOut = (BitOutAttribute)attr;
            return (V)Integer.valueOf(this.bitEnd[bitOut.which]);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == StdAttr.FACING) {
            Direction newFacing = (Direction)value;
            if (this.facing.equals(newFacing)) {
                return;
            }
            this.facing = (Direction)value;
            this.configureOptions();
            this.parameters = null;
        } else if (attr == ATTR_FANOUT) {
            int newValue = (Integer)value;
            byte[] bits = this.bitEnd;
            for (int i = 0; i < bits.length; ++i) {
                if (bits[i] <= newValue) continue;
                bits[i] = (byte)newValue;
            }
            if (this.fanout == (byte)newValue) {
                return;
            }
            this.fanout = (byte)newValue;
            this.configureOptions();
            this.configureDefaults();
            this.parameters = null;
        } else if (attr == ATTR_WIDTH) {
            BitWidth width = (BitWidth)value;
            if (this.bitEnd.length == width.getWidth()) {
                return;
            }
            this.bitEnd = new byte[width.getWidth()];
            this.configureOptions();
            this.configureDefaults();
        } else if (attr == ATTR_SPACING) {
            Integer s = (Integer)value;
            if (s == this.spacing) {
                return;
            }
            this.spacing = s;
            this.parameters = null;
        } else if (attr == ATTR_APPEARANCE) {
            AttributeOption appearance = (AttributeOption)value;
            if (this.appear.equals(appearance)) {
                return;
            }
            this.appear = appearance;
            this.parameters = null;
        } else {
            int val;
            if (!(attr instanceof BitOutAttribute)) throw new IllegalArgumentException("unknown attribute " + String.valueOf(attr));
            BitOutAttribute bitOutAttr = (BitOutAttribute)attr;
            int n = val = value instanceof Integer ? (Integer)value : ((BitOutOption)value).value + 1;
            if (val < 0 || val > this.fanout) return;
            if (this.bitEnd[bitOutAttr.which] == (byte)val) {
                return;
            }
            this.bitEnd[bitOutAttr.which] = (byte)val;
        }
        this.fireAttributeValueChanged(attr, value, null);
    }

    @Override
    public <V> List<Attribute<?>> attributesMayAlsoBeChanged(Attribute<V> attr, V value) {
        if (attr != ATTR_FANOUT && attr != ATTR_WIDTH) {
            return null;
        }
        if (Objects.equals(this.getValue(attr), value)) {
            return null;
        }
        ArrayList answer = new ArrayList(this.bitEnd.length);
        for (int index = 0; index < this.bitEnd.length; ++index) {
            answer.add(this.getBitOutAttribute(index));
        }
        return answer;
    }

    private static class BitOutOption {
        final int value;
        final boolean isVertical;
        final boolean isLast;

        BitOutOption(int value, boolean isVertical, boolean isLast) {
            this.value = value;
            this.isVertical = isVertical;
            this.isLast = isLast;
        }

        public String toString() {
            if (this.value < 0) {
                return Strings.S.get("splitterBitNone");
            }
            String ret = "" + this.value;
            Direction noteDir = this.value == 0 ? (this.isVertical ? Direction.NORTH : Direction.EAST) : (this.isLast ? (this.isVertical ? Direction.SOUTH : Direction.WEST) : null);
            if (noteDir != null) {
                ret = ret + " (" + noteDir.toVerticalDisplayString() + ")";
            }
            return ret;
        }
    }

    public static class BitOutAttribute
    extends Attribute<Integer> {
        final int which;
        BitOutOption[] options;

        private BitOutAttribute(int which, BitOutOption[] options) {
            super("bit" + which, Strings.S.getter("splitterBitAttr", "" + which));
            this.which = which;
            this.options = options;
        }

        private BitOutAttribute createCopy() {
            return new BitOutAttribute(this.which, this.options);
        }

        public boolean sameOptions(BitOutAttribute other) {
            if (this.options.length != other.options.length) {
                return false;
            }
            for (BitOutOption a : this.options) {
                boolean found = false;
                for (BitOutOption b : other.options) {
                    if (!a.toString().equals(b.toString())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }

        @Override
        public Component getCellEditor(Integer value) {
            Integer index = value;
            ComboBox<BitOutOption> combo = new ComboBox<BitOutOption>((T[])this.options);
            combo.setSelectedIndex(index);
            combo.setMaximumRowCount(this.options.length);
            return combo;
        }

        public Object getDefault() {
            return this.which + 1;
        }

        @Override
        public Integer parse(String value) {
            if (value.equals(SplitterAttributes.UNCHOSEN_VAL)) {
                return 0;
            }
            return 1 + Integer.parseInt(value);
        }

        @Override
        public String toDisplayString(Integer value) {
            return this.options[value].toString();
        }

        @Override
        public String toStandardString(Integer value) {
            Integer index = value;
            if (index == 0) {
                return SplitterAttributes.UNCHOSEN_VAL;
            }
            return "" + (index - 1);
        }
    }
}

