/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.MapComponent;
import java.util.ArrayList;
import java.util.List;

public class CircuitMapInfo {
    private BoardRectangle rect;
    private Long constValue;
    private int pinid = -1;
    private int ioid = -1;
    private boolean oldMapFormat = true;
    private MapComponent myMap;
    private ArrayList<CircuitMapInfo> pinmaps;

    public CircuitMapInfo() {
        this.rect = null;
        this.constValue = null;
    }

    public CircuitMapInfo(BoardRectangle rect) {
        this.rect = rect;
        this.constValue = null;
    }

    public CircuitMapInfo(Long val) {
        this.rect = null;
        this.constValue = val;
    }

    public CircuitMapInfo(MapComponent map) {
        this.oldMapFormat = false;
        this.myMap = map;
    }

    public CircuitMapInfo(int sourceId, int ioId, int xpos, int ypos) {
        this.pinid = sourceId;
        this.ioid = ioId;
        this.rect = new BoardRectangle(xpos, ypos, 1, 1);
    }

    public CircuitMapInfo(int x, int y) {
        this.oldMapFormat = false;
        this.rect = new BoardRectangle(x, y, 1, 1);
    }

    public void addPinMap(CircuitMapInfo map) {
        if (this.pinmaps == null) {
            this.pinmaps = new ArrayList();
            this.oldMapFormat = false;
        }
        this.pinmaps.add(map);
    }

    public void addPinMap(int x, int y, int loc) {
        if (this.pinmaps == null) {
            this.pinmaps = new ArrayList();
            this.oldMapFormat = false;
        }
        int sloc = this.pinmaps.size();
        this.pinmaps.add(new CircuitMapInfo(sloc, loc, x, y));
    }

    public boolean isSinglePin() {
        return this.pinid >= 0;
    }

    public int getPinId() {
        return this.pinid;
    }

    public int getIoId() {
        return this.ioid;
    }

    public BoardRectangle getRectangle() {
        return this.rect;
    }

    public Long getConstValue() {
        return this.constValue;
    }

    public boolean isOpen() {
        return this.rect == null && this.constValue == null && this.oldMapFormat;
    }

    public boolean isConst() {
        return this.rect == null && this.constValue != null;
    }

    public boolean isOldFormat() {
        return this.oldMapFormat;
    }

    public MapComponent getMap() {
        return this.myMap;
    }

    public List<CircuitMapInfo> getPinMaps() {
        return this.pinmaps;
    }
}

