/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.designrulecheck.ConnectionEnd;
import com.cburch.logisim.fpga.designrulecheck.ConnectionPoint;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.designrulecheck.Net;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.LineBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CircuitHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private final Circuit myCircuit;

    public CircuitHdlGeneratorFactory(Circuit source) {
        this.myCircuit = source;
        this.getWiresPortsDuringHDLWriting = true;
    }

    @Override
    public void getGenerationTimeWiresPorts(Netlist theNetlist, AttributeSet attrs) {
        int nrOfBits;
        String name;
        netlistComponent selectedInput;
        int inOutBubbles = theNetlist.numberOfInOutBubbles();
        int inputBubbles = theNetlist.getNumberOfInputBubbles();
        int outputBubbles = theNetlist.numberOfOutputBubbles();
        for (Net wire : theNetlist.getAllNets()) {
            if (wire.isBus()) continue;
            this.myWires.addWire(String.format("%s%d", "s_logisimNet", theNetlist.getNetId(wire)), 1);
        }
        for (Net wire : theNetlist.getAllNets()) {
            if (!wire.isBus() || !wire.isRootNet()) continue;
            this.myWires.addWire(String.format("%s%d", "s_logisimBus", theNetlist.getNetId(wire)), wire.getBitWidth());
        }
        if (inOutBubbles > 0) {
            this.myPorts.add("inout", "logisimInOutBubbles", inOutBubbles > 1 ? inOutBubbles : 0, 0);
        }
        for (int clock = 0; clock < theNetlist.numberOfClockTrees(); ++clock) {
            this.myPorts.add("input", String.format("%s%d", "logisimClockTree", clock), 5, 0);
        }
        if (theNetlist.requiresGlobalClockConnection()) {
            this.myPorts.add("input", "fpgaGlobalClock", 1, 0);
        }
        if (inputBubbles > 0) {
            this.myPorts.add("input", "logisimInputBubbles", inputBubbles > 1 ? inputBubbles : 0, 0);
        }
        for (int input = 0; input < theNetlist.getNumberOfInputPorts(); ++input) {
            selectedInput = theNetlist.getInputPin(input);
            if (selectedInput == null) continue;
            name = selectedInput.getComponent().getAttributeSet().getValue(StdAttr.LABEL);
            nrOfBits = selectedInput.getComponent().getAttributeSet().getValue(StdAttr.WIDTH).getWidth();
            this.myPorts.add("input", CorrectLabel.getCorrectLabel(name), nrOfBits, 0);
        }
        if (outputBubbles > 0) {
            this.myPorts.add("output", "logisimOutputBubbles", outputBubbles > 1 ? outputBubbles : 0, 0);
        }
        for (int output = 0; output < theNetlist.numberOfOutputPorts(); ++output) {
            selectedInput = theNetlist.getOutputPin(output);
            if (selectedInput == null) continue;
            name = selectedInput.getComponent().getAttributeSet().getValue(StdAttr.LABEL);
            nrOfBits = selectedInput.getComponent().getAttributeSet().getValue(StdAttr.WIDTH).getWidth();
            this.myPorts.add("output", CorrectLabel.getCorrectLabel(name), nrOfBits, 0);
        }
    }

    @Override
    public boolean generateAllHDLDescriptions(Set<String> handledComponents, String workingDir, List<String> hierarchy) {
        return this.generateAllHDLDescriptions(handledComponents, workingDir, hierarchy, false);
    }

    public boolean generateAllHDLDescriptions(Set<String> handledComponents, String workingDir, List<String> hierarchy, boolean gatedInstance) {
        Netlist myNetList;
        if (this.myCircuit == null) {
            return false;
        }
        if (hierarchy == null) {
            hierarchy = new ArrayList<String>();
        }
        if ((myNetList = this.myCircuit.getNetList()) == null) {
            return false;
        }
        Object workPath = workingDir;
        if (!((String)workPath).endsWith(File.separator)) {
            workPath = (String)workPath + File.separator;
        }
        myNetList.setCurrentHierarchyLevel(hierarchy);
        for (netlistComponent thisComponent : myNetList.getNormalComponents()) {
            String componentName = thisComponent.getComponent().getFactory().getHDLName(thisComponent.getComponent().getAttributeSet());
            if (handledComponents.contains(componentName)) continue;
            HdlGeneratorFactory worker = thisComponent.getComponent().getFactory().getHDLGenerator(thisComponent.getComponent().getAttributeSet());
            if (worker == null) {
                Reporter.report.addFatalError("INTERNAL ERROR: Cannot find the VHDL generator factory for component " + componentName);
                return false;
            }
            if (!worker.isOnlyInlined()) {
                if (!Hdl.writeEntity((String)workPath + worker.getRelativeDirectory(), worker.getEntity(myNetList, thisComponent.getComponent().getAttributeSet(), componentName), componentName)) {
                    return false;
                }
                if (!Hdl.writeArchitecture((String)workPath + worker.getRelativeDirectory(), worker.getArchitecture(myNetList, thisComponent.getComponent().getAttributeSet(), componentName), componentName)) {
                    return false;
                }
            }
            handledComponents.add(componentName);
        }
        for (netlistComponent thisCircuit : myNetList.getSubCircuits()) {
            CircuitHdlGeneratorFactory worker = (CircuitHdlGeneratorFactory)thisCircuit.getComponent().getFactory().getHDLGenerator(thisCircuit.getComponent().getAttributeSet());
            if (worker == null) {
                Reporter.report.addFatalError("INTERNAL ERROR: Unable to get a subcircuit VHDL generator for '" + thisCircuit.getComponent().getFactory().getName() + "'");
                return false;
            }
            hierarchy.add(CorrectLabel.getCorrectLabel(thisCircuit.getComponent().getAttributeSet().getValue(StdAttr.LABEL)));
            if (!worker.generateAllHDLDescriptions(handledComponents, workingDir, hierarchy, thisCircuit.isGatedInstance())) {
                return false;
            }
            hierarchy.remove(hierarchy.size() - 1);
        }
        String componentName = CorrectLabel.getCorrectLabel(this.myCircuit.getName());
        if (gatedInstance) {
            componentName = componentName.concat("_gated");
        }
        if (!handledComponents.contains(componentName)) {
            if (!Hdl.writeEntity((String)workPath + this.getRelativeDirectory(), this.getEntity(myNetList, null, componentName), componentName)) {
                return false;
            }
            if (!Hdl.writeArchitecture((String)workPath + this.getRelativeDirectory(), this.getArchitecture(myNetList, null, componentName), componentName)) {
                return false;
            }
        }
        handledComponents.add(componentName);
        return true;
    }

    private String getBubbleIndex(netlistComponent comp, bubbleType type) {
        String fmt = "{{<}}{{1}} {{2}} {{3}}{{>}}";
        return switch (type.ordinal()) {
            case 0 -> LineBuffer.format("{{<}}{{1}} {{2}} {{3}}{{>}}", comp.getLocalBubbleInputEndId(), Hdl.vectorLoopId(), comp.getLocalBubbleInputStartId());
            case 1 -> LineBuffer.format("{{<}}{{1}} {{2}} {{3}}{{>}}", comp.getLocalBubbleOutputEndId(), Hdl.vectorLoopId(), comp.getLocalBubbleOutputStartId());
            case 2 -> LineBuffer.format("{{<}}{{1}} {{2}} {{3}}{{>}}", comp.getLocalBubbleInOutEndId(), Hdl.vectorLoopId(), comp.getLocalBubbleInOutStartId());
            default -> "";
        };
    }

    @Override
    public LineBuffer getComponentDeclarationSection(Netlist theNetlist, AttributeSet attrs) {
        HdlGeneratorFactory worker;
        String compName;
        LineBuffer components = LineBuffer.getBuffer();
        HashSet<String> instantiatedComponents = new HashSet<String>();
        for (netlistComponent gate : theNetlist.getNormalComponents()) {
            compName = gate.getComponent().getFactory().getHDLName(gate.getComponent().getAttributeSet());
            if (instantiatedComponents.contains(compName)) continue;
            instantiatedComponents.add(compName);
            worker = gate.getComponent().getFactory().getHDLGenerator(gate.getComponent().getAttributeSet());
            if (worker == null || worker.isOnlyInlined()) continue;
            components.empty().add(worker.getComponentInstantiation(theNetlist, gate.getComponent().getAttributeSet(), compName));
        }
        instantiatedComponents.clear();
        for (netlistComponent gate : theNetlist.getSubCircuits()) {
            compName = gate.getComponent().getFactory().getHDLName(gate.getComponent().getAttributeSet());
            if (gate.isGatedInstance()) {
                compName = compName.concat("_gated");
            }
            if (instantiatedComponents.contains(compName)) continue;
            instantiatedComponents.add(compName);
            worker = gate.getComponent().getFactory().getHDLGenerator(gate.getComponent().getAttributeSet());
            SubcircuitFactory sub = (SubcircuitFactory)gate.getComponent().getFactory();
            if (worker == null) continue;
            components.empty().add(worker.getComponentInstantiation(sub.getSubcircuit().getNetList(), gate.getComponent().getAttributeSet(), compName));
        }
        return components;
    }

    public Map<String, String> getHdlWiring(Netlist theNets) {
        HashMap<String, String> contents = new HashMap<String, String>();
        for (Net thisNet : theNets.getAllNets()) {
            if (!thisNet.isForcedRootNet()) continue;
            Integer wireId = theNets.getNetId(thisNet);
            for (int bit = 0; bit < thisNet.getBitWidth(); ++bit) {
                String sourceWire;
                String destination;
                for (ConnectionPoint source : thisNet.getSourceNets(bit)) {
                    destination = thisNet.isBus() ? LineBuffer.formatHdl("{{1}}{{2}}{{<}}{{3}}{{>}}", "s_logisimBus", wireId, bit) : LineBuffer.formatHdl("{{1}}{{2}}", "s_logisimNet", wireId);
                    sourceWire = LineBuffer.formatHdl("{{1}}{{2}}{{<}}{{3}}{{>}}", "s_logisimBus", theNets.getNetId(source.getParentNet()), source.getParentNetBitIndex());
                    contents.put(destination, sourceWire);
                }
                for (ConnectionPoint source : thisNet.getSinkNets(bit)) {
                    destination = LineBuffer.formatHdl("{{1}}{{2}}{{<}}{{3}}{{>}}", "s_logisimBus", theNets.getNetId(source.getParentNet()), source.getParentNetBitIndex());
                    sourceWire = thisNet.isBus() ? LineBuffer.formatHdl("{{1}}{{2}}{{<}}{{3}}{{>}}", "s_logisimBus", wireId, bit) : LineBuffer.formatHdl("{{1}}{{2}}", "s_logisimNet", wireId);
                    contents.put(destination, sourceWire);
                }
            }
        }
        return contents;
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetList, AttributeSet attrs) {
        String compName;
        long id;
        HdlGeneratorFactory worker;
        String pinName;
        int i;
        LineBuffer contents = LineBuffer.getHdlBuffer();
        boolean isFirstLine = true;
        HashMap<String, Long> compIds = new HashMap<String, Long>();
        HashMap<String, String> wires = new HashMap<String, String>();
        for (netlistComponent clockSource : theNetList.getClockSources()) {
            if (!clockSource.isEndConnected(0)) {
                String msg = String.format("Clock component found with no connection, skipping: '%s'", clockSource.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
                Reporter.report.addWarning(msg);
                continue;
            }
            String clockNet = Hdl.getClockNetName(clockSource, 0, theNetList);
            if (clockNet.isEmpty()) {
                Reporter.report.addFatalError("INTERNAL ERROR: Cannot find clocknet!");
            }
            String destination = Hdl.getNetName(clockSource, 0, true, theNetList);
            String source = theNetList.requiresGlobalClockConnection() ? "fpgaGlobalClock" : LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", clockNet, 0);
            wires.put(destination, source);
        }
        if (!wires.isEmpty()) {
            contents.empty().addRemarkBlock("All clock generator connections are defined here");
            Hdl.addAllWiresSorted(contents, wires);
        }
        wires.putAll(this.getHdlWiring(theNetList));
        if (!wires.isEmpty()) {
            contents.empty().addRemarkBlock("Here all wiring is defined");
            Hdl.addAllWiresSorted(contents, wires);
        }
        for (i = 0; i < theNetList.getNumberOfInputPorts(); ++i) {
            netlistComponent myInput = theNetList.getInputPin(i);
            pinName = CorrectLabel.getCorrectLabel(myInput.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            wires.putAll(CircuitHdlGeneratorFactory.getSignalMap(pinName, myInput, 0, theNetList));
        }
        if (!wires.isEmpty()) {
            contents.empty().addRemarkBlock("Here all input connections are defined");
            Hdl.addAllWiresSorted(contents, wires);
        }
        for (i = 0; i < theNetList.numberOfOutputPorts(); ++i) {
            netlistComponent myOutput = theNetList.getOutputPin(i);
            pinName = CorrectLabel.getCorrectLabel(myOutput.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            wires.putAll(CircuitHdlGeneratorFactory.getSignalMap(pinName, myOutput, 0, theNetList));
        }
        if (!wires.isEmpty()) {
            contents.empty().addRemarkBlock("Here all output connections are defined");
            Hdl.addAllWiresSorted(contents, wires);
        }
        isFirstLine = true;
        for (netlistComponent comp : theNetList.getNormalComponents()) {
            AttributeSet thisAttrs;
            worker = comp.getComponent().getFactory().getHDLGenerator(comp.getComponent().getAttributeSet());
            if (worker == null || !worker.isOnlyInlined()) continue;
            String inlinedName = comp.getComponent().getFactory().getHDLName(comp.getComponent().getAttributeSet());
            String InlinedId = "InlinedComponent";
            long l = id = compIds.containsKey("InlinedComponent") ? (Long)compIds.get("InlinedComponent") : 1L;
            if (isFirstLine) {
                contents.add("");
                contents.addRemarkBlock("Here all in-lined components are defined");
                isFirstLine = false;
            }
            boolean hasLabel = (thisAttrs = comp.getComponent().getAttributeSet()).containsAttribute(StdAttr.LABEL) && !thisAttrs.getValue(StdAttr.LABEL).isEmpty();
            String compName2 = hasLabel ? CorrectLabel.getCorrectLabel(thisAttrs.getValue(StdAttr.LABEL)) : "";
            String remarkLine = LineBuffer.format("{{1}}{{2}}{{3}}", comp.getComponent().getFactory().getDisplayName(), hasLabel ? ": " : "", compName2);
            contents.empty().addRemarkLine(remarkLine).add(worker.getInlinedCode(theNetList, id++, comp, inlinedName));
            compIds.put("InlinedComponent", id);
        }
        isFirstLine = true;
        for (netlistComponent comp : theNetList.getNormalComponents()) {
            worker = comp.getComponent().getFactory().getHDLGenerator(comp.getComponent().getAttributeSet());
            if (worker == null || worker.isOnlyInlined()) continue;
            compName = comp.getComponent().getFactory().getHDLName(comp.getComponent().getAttributeSet());
            String compId = "NormalComponent";
            long l = id = compIds.containsKey("NormalComponent") ? (Long)compIds.get("NormalComponent") : 1L;
            if (isFirstLine) {
                contents.empty().addRemarkBlock("Here all normal components are defined");
                isFirstLine = false;
            }
            contents.add(worker.getComponentMap(theNetList, id++, comp, compName)).empty();
            compIds.put("NormalComponent", id);
        }
        isFirstLine = true;
        for (netlistComponent comp : theNetList.getSubCircuits()) {
            LineBuffer compMap;
            worker = comp.getComponent().getFactory().getHDLGenerator(comp.getComponent().getAttributeSet());
            if (worker == null) continue;
            compName = comp.getComponent().getFactory().getHDLName(comp.getComponent().getAttributeSet());
            if (comp.isGatedInstance()) {
                compName = compName.concat("_gated");
            }
            String CompId = "SubCircuits";
            long l = id = compIds.containsKey("SubCircuits") ? (Long)compIds.get("SubCircuits") : 1L;
            if ((compMap = worker.getComponentMap(theNetList, id++, comp, compName)).isEmpty()) continue;
            if (isFirstLine) {
                contents.empty().addRemarkBlock("Here all sub-circuits are defined");
                isFirstLine = false;
            }
            compIds.put("SubCircuits", id);
            contents.empty().add(compMap);
        }
        contents.empty();
        return contents;
    }

    @Override
    public Map<String, String> getPortMap(Netlist nets, Object theMapInfo) {
        int nrOfOutputPorts;
        int nrOfInOutPorts;
        int nrOfInputPorts;
        int i;
        int nrOfIOBubbles;
        TreeMap<String, String> portMap = new TreeMap<String, String>();
        if (theMapInfo == null) {
            return null;
        }
        boolean topLevel = theMapInfo instanceof MappableResourcesContainer;
        netlistComponent componentInfo = topLevel ? null : (netlistComponent)theMapInfo;
        MappableResourcesContainer mapInfo = topLevel ? (MappableResourcesContainer)theMapInfo : null;
        String Preamble = topLevel ? "s_" : "";
        SubcircuitFactory sub = topLevel ? null : (SubcircuitFactory)componentInfo.getComponent().getFactory();
        Netlist myNetList = topLevel ? nets : sub.getSubcircuit().getNetList();
        for (int i2 = 0; i2 < myNetList.numberOfClockTrees(); ++i2) {
            portMap.put("logisimClockTree" + i2, Preamble + "logisimClockTree" + i2);
        }
        if (myNetList.requiresGlobalClockConnection()) {
            portMap.put("fpgaGlobalClock", "fpgaGlobalClock");
        }
        if (myNetList.getNumberOfInputBubbles() > 0) {
            portMap.put("logisimInputBubbles", LineBuffer.format("{{1}}{{2}}", topLevel ? Preamble : "logisimInputBubbles", topLevel ? "logisimInputBubbles" : this.getBubbleIndex(componentInfo, bubbleType.INPUT)));
        }
        if (myNetList.numberOfOutputBubbles() > 0) {
            portMap.put("logisimOutputBubbles", LineBuffer.format("{{1}}{{2}}", topLevel ? Preamble : "logisimOutputBubbles", topLevel ? "logisimOutputBubbles" : this.getBubbleIndex(componentInfo, bubbleType.OUTPUT)));
        }
        if ((nrOfIOBubbles = myNetList.numberOfInOutBubbles()) > 0) {
            if (topLevel) {
                StringBuilder vector = new StringBuilder();
                for (i = nrOfIOBubbles - 1; i >= 0; --i) {
                    int compPin = -1;
                    MapComponent map = null;
                    for (ArrayList<String> key : mapInfo.getMappableResources().keySet()) {
                        int id;
                        MapComponent comp = mapInfo.getMappableResources().get(key);
                        if (!comp.hasIos() || (id = comp.getIoBubblePinId(i)) < 0) continue;
                        compPin = id;
                        map = comp;
                        break;
                    }
                    if (map == null || compPin < 0) {
                        Reporter.report.addError("BUG: did not find IOpin");
                        continue;
                    }
                    if (!map.isMapped(compPin) || map.isOpenMapped(compPin)) {
                        if (Hdl.isVhdl()) {
                            portMap.put(LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", "logisimInOutBubbles", i), "OPEN");
                            continue;
                        }
                        if (vector.length() != 0) {
                            vector.append(",");
                        }
                        vector.append("OPEN");
                        continue;
                    }
                    if (Hdl.isVhdl()) {
                        portMap.put(LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", "logisimInOutBubbles", i), (map.isExternalInverted(compPin) ? "n_" : "") + map.getHdlString(compPin));
                        continue;
                    }
                    if (vector.length() != 0) {
                        vector.append(",");
                    }
                    vector.append(map.isExternalInverted(compPin) ? "n_" : "").append(map.getHdlString(compPin));
                }
                if (Hdl.isVerilog()) {
                    portMap.put("logisimInOutBubbles", vector.toString());
                }
            } else {
                portMap.put("logisimInOutBubbles", "logisimInOutBubbles" + this.getBubbleIndex(componentInfo, bubbleType.INOUT));
            }
        }
        if ((nrOfInputPorts = myNetList.getNumberOfInputPorts()) > 0) {
            for (i = 0; i < nrOfInputPorts; ++i) {
                netlistComponent selected = myNetList.getInputPin(i);
                if (selected == null) continue;
                String pinLabel = CorrectLabel.getCorrectLabel(selected.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
                if (topLevel) {
                    portMap.put(pinLabel, Preamble + pinLabel);
                    continue;
                }
                int endId = nets.getEndIndex(componentInfo, pinLabel, false);
                if (endId < 0) {
                    Reporter.report.addFatalError(String.format("INTERNAL ERROR! Could not find the end-index of a sub-circuit component: '%s'", pinLabel));
                    continue;
                }
                portMap.putAll(Hdl.getNetMap(pinLabel, true, componentInfo, endId, nets));
            }
        }
        if ((nrOfInOutPorts = myNetList.numberOfInOutPorts()) > 0) {
            for (int i3 = 0; i3 < nrOfInOutPorts; ++i3) {
                netlistComponent selected = myNetList.getInOutPin(i3);
                if (selected == null) continue;
                String pinLabel = CorrectLabel.getCorrectLabel(selected.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
                if (topLevel) continue;
                int endId = nets.getEndIndex(componentInfo, pinLabel, false);
                if (endId < 0) {
                    Reporter.report.addFatalError(String.format("INTERNAL ERROR! Could not find the end-index of a sub-circuit component: '%s'", pinLabel));
                    continue;
                }
                portMap.putAll(Hdl.getNetMap(pinLabel, true, componentInfo, endId, nets));
            }
        }
        if ((nrOfOutputPorts = myNetList.numberOfOutputPorts()) > 0) {
            for (int i4 = 0; i4 < nrOfOutputPorts; ++i4) {
                netlistComponent selected = myNetList.getOutputPin(i4);
                if (selected == null) continue;
                String pinLabel = CorrectLabel.getCorrectLabel(selected.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
                if (topLevel) {
                    portMap.put(pinLabel, Preamble + pinLabel);
                    continue;
                }
                int endid = nets.getEndIndex(componentInfo, pinLabel, true);
                if (endid < 0) {
                    Reporter.report.addFatalError(String.format("INTERNAL ERROR! Could not find the end-index of a sub-circuit component: '%s'", pinLabel));
                    continue;
                }
                portMap.putAll(Hdl.getNetMap(pinLabel, true, componentInfo, endid, nets));
            }
        }
        return portMap;
    }

    private static Map<String, String> getSignalMap(String portName, netlistComponent comp, int endIndex, Netlist theNets) {
        HashMap<String, String> signal = new HashMap<String, String>();
        if (endIndex < 0 || endIndex >= comp.nrOfEnds()) {
            Reporter.report.addFatalErrorFmt("INTERNAL ERROR: Component tried to index non-existing SolderPoint: '%s'", comp.getComponent().getAttributeSet().getValue(StdAttr.LABEL));
            return signal;
        }
        ConnectionEnd connectionInformation = comp.getEnd(endIndex);
        boolean isInputConnection = connectionInformation.isOutputEnd();
        int nrOfBits = connectionInformation.getNrOfBits();
        if (nrOfBits == 1) {
            if (isInputConnection) {
                if (comp.isEndConnected(endIndex)) {
                    signal.put(Hdl.getNetName(comp, endIndex, true, theNets), portName);
                }
            } else if (comp.isEndConnected(endIndex)) {
                signal.put(portName, Hdl.getNetName(comp, endIndex, true, theNets));
            } else {
                Reporter.report.addSevereWarning("Found an unconnected output pin, tied the pin to ground!");
                signal.put(portName, Hdl.zeroBit());
            }
        } else {
            boolean connected = false;
            for (int i = 0; i < nrOfBits; ++i) {
                if (connectionInformation.get((byte)i).getParentNet() == null) continue;
                connected = true;
            }
            if (!connected) {
                if (!isInputConnection) {
                    Reporter.report.addSevereWarning("Found an unconnected output bus pin, tied all the pin bits to ground!");
                    signal.put(portName, Hdl.getZeroVector(nrOfBits, true));
                }
            } else if (theNets.isContinuesBus(comp, endIndex)) {
                if (isInputConnection) {
                    signal.put(Hdl.getBusNameContinues(comp, endIndex, theNets), portName);
                } else {
                    signal.put(portName, Hdl.getBusNameContinues(comp, endIndex, theNets));
                }
            } else {
                for (int bit = 0; bit < nrOfBits; ++bit) {
                    String connectedNet;
                    String bitConnection = LineBuffer.formatHdl("{{1}}{{<}}{{2}}{{>}}", portName, bit);
                    ConnectionPoint solderPoint = connectionInformation.get((byte)bit);
                    if (solderPoint.getParentNet() == null) {
                        if (isInputConnection) continue;
                        Reporter.report.addSevereWarning(String.format("Found an unconnected output bus pin, tied bit %d to ground!", bit));
                        signal.put(bitConnection, Hdl.zeroBit());
                        continue;
                    }
                    String string = connectedNet = solderPoint.getParentNet().getBitWidth() == 1 ? LineBuffer.formatHdl("{{1}}{{2}}", "s_logisimNet", theNets.getNetId(solderPoint.getParentNet())) : LineBuffer.formatHdl("{{1}}{{2}}{{<}}{{3}}{{>}}", "s_logisimBus", theNets.getNetId(solderPoint.getParentNet()), solderPoint.getParentNetBitIndex());
                    if (isInputConnection) {
                        signal.put(connectedNet, bitConnection);
                        continue;
                    }
                    signal.put(bitConnection, connectedNet);
                }
            }
        }
        return signal;
    }

    private static enum bubbleType {
        INPUT,
        OUTPUT,
        INOUT;

    }
}

