/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.VariableList;
import com.cburch.logisim.analyze.model.VariableListEvent;
import com.cburch.logisim.analyze.model.VariableListListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

class OutputSelector {
    private final VariableList source;
    private final JLabel label = new JLabel();
    private final JComboBox<String> select = new JComboBox();

    public OutputSelector(AnalyzerModel model) {
        this.source = model.getOutputs();
        Model listModel = new Model();
        this.select.setModel(listModel);
        this.select.setRenderer(listModel.getMyRenderer());
        this.source.addVariableListListener(listModel);
    }

    public void addItemListener(ItemListener l) {
        this.select.addItemListener(l);
    }

    public JPanel createPanel() {
        JPanel ret = new JPanel();
        ret.add(this.label);
        ret.add(this.select);
        return ret;
    }

    public JComboBox<String> getComboBox() {
        return this.select;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public String getSelectedOutput() {
        String value = (String)this.select.getSelectedItem();
        if (value != null && !this.source.bits.contains(value)) {
            value = this.source.bits.isEmpty() ? null : this.source.bits.get(0);
            this.select.setSelectedItem(value);
        }
        return value;
    }

    void localeChanged() {
        this.label.setText(Strings.S.get("outputSelectLabel"));
    }

    public void removeItemListener(ItemListener l) {
        this.select.removeItemListener(l);
    }

    private class Model
    extends AbstractListModel<String>
    implements ComboBoxModel<String>,
    VariableListListener {
        private static final long serialVersionUID = 1L;
        private String selected;
        private final AttributedJLabel myRenderer = new AttributedJLabel();

        private Model() {
        }

        public ListCellRenderer<Object> getMyRenderer() {
            return this.myRenderer;
        }

        @Override
        public String getElementAt(int index) {
            return OutputSelector.this.source.bits.get(index);
        }

        @Override
        public String getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return OutputSelector.this.source.bits.size();
        }

        @Override
        public void listChanged(VariableListEvent event) {
            int oldSize = OutputSelector.this.select.getItemCount();
            int newSize = OutputSelector.this.source.bits.size();
            this.fireContentsChanged(this, 0, Math.max(oldSize, newSize));
            if (!OutputSelector.this.source.bits.contains(this.selected)) {
                this.selected = newSize == 0 ? null : OutputSelector.this.source.bits.get(0);
                OutputSelector.this.select.setSelectedItem(this.selected);
            }
        }

        @Override
        public void setSelectedItem(Object value) {
            this.selected = (String)value;
        }

        private class AttributedJLabel
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            private AttributedJLabel() {
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                Font f = this.getFont();
                Insets i = this.getInsets();
                dim.height = i.top + i.bottom + f.getSize() + f.getSize() / 2;
                return dim;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText((String)value);
                return this;
            }

            @Override
            public void paint(Graphics g) {
                AttributedString as;
                String txt = this.getText();
                if (txt == null) {
                    super.paint(g);
                    return;
                }
                Graphics2D g2 = (Graphics2D)g.create();
                Insets i = this.getInsets();
                Font font = this.getFont();
                g2.setPaint(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                FontRenderContext frc = g2.getFontRenderContext();
                if (txt.contains(":")) {
                    int idx = txt.indexOf(58);
                    as = new AttributedString(txt.substring(0, idx) + txt.substring(idx + 1));
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, idx, txt.length() - 1);
                } else if (txt.contains("[")) {
                    int start = txt.indexOf(91);
                    int stop = txt.lastIndexOf(93);
                    as = new AttributedString(txt.substring(0, start) + txt.substring(start + 1, stop));
                    as.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, start, start + (stop - start - 1));
                } else {
                    as = new AttributedString(txt);
                }
                as.addAttribute(TextAttribute.FAMILY, font.getFamily());
                as.addAttribute(TextAttribute.SIZE, font.getSize());
                TextLayout tl = new TextLayout(as.getIterator(), frc);
                g2.setColor(this.getForeground());
                tl.draw(g2, i.left, (float)i.top + tl.getAscent());
            }
        }
    }
}

