/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.hdl;

import com.cburch.hdl.Strings;
import com.cburch.logisim.std.hdl.HdlContentEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class HdlFile {
    public static void open(File file, HdlContentEditor editor) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String l;
            StringBuilder content = new StringBuilder();
            while ((l = in.readLine()) != null) {
                content.append(l);
                content.append(System.getProperty("line.separator"));
            }
            editor.setText(content.toString());
        }
        catch (IOException ex) {
            throw new IOException(Strings.S.get("hdlFileReaderError"));
        }
    }

    public static void save(File file, HdlContentEditor editor) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            String data = editor.getText();
            out.write(data, 0, data.length());
        }
        catch (IOException ex) {
            throw new IOException(Strings.S.get("hdlFileWriterError"));
        }
    }
}

