/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.tools;

import com.cburch.draw.actions.ModelMoveHandleAction;
import com.cburch.draw.actions.ModelRemoveAction;
import com.cburch.draw.actions.ModelTranslateAction;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.canvas.Selection;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.icons.SelectIcon;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class SelectTool
extends AbstractTool {
    private static final int IDLE = 0;
    private static final int MOVE_ALL = 1;
    private static final int RECT_SELECT = 2;
    private static final int RECT_TOGGLE = 3;
    private static final int MOVE_HANDLE = 4;
    private static final int DRAG_TOLERANCE = 2;
    private static final int HANDLE_SIZE = 8;
    private static final Color RECT_SELECT_BACKGROUND = new Color(0, 0, 0, 32);
    private static final SelectIcon icon = new SelectIcon();
    private int curAction = 0;
    private List<CanvasObject> beforePressSelection;
    private Handle beforePressHandle;
    private Location dragStart;
    private Location dragEnd = this.dragStart = Location.create(0, 0, false);
    private boolean dragEffective = false;
    private int lastMouseX;
    private int lastMouseY;
    private HandleGesture curGesture;

    private static CanvasObject getObjectAt(CanvasModel model, int x, int y, boolean assumeFilled) {
        Location loc = Location.create(x, y, false);
        for (CanvasObject o : model.getObjectsFromTop()) {
            if (!o.contains(loc, assumeFilled)) continue;
            return o;
        }
        return null;
    }

    @Override
    public void cancelMousePress(Canvas canvas) {
        List<CanvasObject> before = this.beforePressSelection;
        Handle handle = this.beforePressHandle;
        this.beforePressSelection = null;
        this.beforePressHandle = null;
        if (before != null) {
            this.curAction = 0;
            Selection sel = canvas.getSelection();
            sel.clearDrawsSuppressed();
            sel.setMovingShapes(Collections.emptySet(), 0, 0);
            sel.clearSelected();
            sel.setSelected(before, true);
            sel.setHandleSelected(handle);
            this.repaintArea(canvas);
        }
    }

    @Override
    public void draw(Canvas canvas, Graphics gfx) {
        boolean drawHandles;
        Selection selection = canvas.getSelection();
        int action = this.curAction;
        Location start = this.dragStart;
        Location end = this.dragEnd;
        HandleGesture gesture = null;
        switch (action) {
            case 1: {
                drawHandles = !this.dragEffective;
                break;
            }
            case 4: {
                boolean bl = drawHandles = !this.dragEffective;
                if (!this.dragEffective) break;
                gesture = this.curGesture;
                break;
            }
            default: {
                drawHandles = true;
            }
        }
        CanvasObject moveHandleObj = null;
        if (gesture != null) {
            moveHandleObj = gesture.getHandle().getObject();
        }
        if (drawHandles) {
            double zoom = 1.0;
            Graphics gfxCopy = gfx.create();
            if (gfxCopy instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)gfxCopy;
                zoom = canvas.getZoomFactor();
                if (zoom != 1.0) {
                    g2d.scale(1.0 / zoom, 1.0 / zoom);
                }
            }
            GraphicsUtil.switchToWidth(gfxCopy, 1);
            int size = (int)Math.ceil(8.0 * Math.sqrt(zoom));
            int offs = size / 2;
            for (CanvasObject obj : selection.getSelected()) {
                List<Handle> handles = action == 4 && obj == moveHandleObj ? obj.getHandles(gesture) : obj.getHandles(null);
                for (Handle han : handles) {
                    int x = han.getX();
                    int y = han.getY();
                    if (action == 1 && this.dragEffective) {
                        Location delta = selection.getMovingDelta();
                        x += delta.getX();
                        y += delta.getY();
                    }
                    x = (int)Math.round(zoom * (double)x);
                    y = (int)Math.round(zoom * (double)y);
                    gfxCopy.clearRect(x - offs, y - offs, size, size);
                    gfxCopy.drawRect(x - offs, y - offs, size, size);
                }
            }
            Handle selHandle = selection.getSelectedHandle();
            if (selHandle != null) {
                int x = selHandle.getX();
                int y = selHandle.getY();
                if (action == 1 && this.dragEffective) {
                    Location delta = selection.getMovingDelta();
                    x += delta.getX();
                    y += delta.getY();
                }
                x = (int)Math.round(zoom * (double)x);
                y = (int)Math.round(zoom * (double)y);
                int[] xs = new int[]{x - offs, x, x + offs, x};
                int[] ys = new int[]{y, y - offs, y, y + offs};
                gfxCopy.setColor(Color.WHITE);
                gfxCopy.fillPolygon(xs, ys, 4);
                gfxCopy.setColor(Color.BLACK);
                gfxCopy.drawPolygon(xs, ys, 4);
            }
        }
        switch (action) {
            case 2: 
            case 3: {
                int t;
                if (!this.dragEffective) break;
                int x0 = start.getX();
                int y0 = start.getY();
                int x1 = end.getX();
                int y1 = end.getY();
                if (x1 < x0) {
                    t = x0;
                    x0 = x1;
                    x1 = t;
                }
                if (y1 < y0) {
                    t = y0;
                    y0 = y1;
                    y1 = t;
                }
                int w = canvas.getWidth();
                int h = canvas.getHeight();
                gfx.setColor(RECT_SELECT_BACKGROUND);
                gfx.fillRect(0, 0, w, y0);
                gfx.fillRect(0, y0, x0, y1 - y0);
                gfx.fillRect(x1, y0, w - x1, y1 - y0);
                gfx.fillRect(0, y1, w, h - y1);
                gfx.setColor(Color.GRAY);
                gfx.drawRect(x0, y0, x1 - x0, y1 - y0);
                break;
            }
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return Collections.emptyList();
    }

    @Override
    public Cursor getCursor(Canvas canvas) {
        return Cursor.getPredefinedCursor(0);
    }

    private int getHandleSize(Canvas canvas) {
        double zoom = canvas.getZoomFactor();
        return (int)Math.ceil(8.0 / Math.sqrt(zoom));
    }

    @Override
    public Icon getIcon() {
        return icon;
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        int code = e.getKeyCode();
        if ((code == 16 || code == 17 || code == 18) && this.curAction != 0) {
            this.setMouse(canvas, this.lastMouseX, this.lastMouseY, e.getModifiersEx());
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        this.keyPressed(canvas, e);
    }

    @Override
    public void keyTyped(Canvas canvas, KeyEvent e) {
        char ch = e.getKeyChar();
        Selection selected = canvas.getSelection();
        if (!(ch != '\b' && ch != '\u007f' || selected.isEmpty())) {
            ArrayList<CanvasObject> toRemove = new ArrayList<CanvasObject>();
            for (CanvasObject shape : selected.getSelected()) {
                if (!shape.canRemove()) continue;
                toRemove.add(shape);
            }
            if (!toRemove.isEmpty()) {
                e.consume();
                CanvasModel model = canvas.getModel();
                canvas.doAction(new ModelRemoveAction(model, toRemove));
                selected.clearSelected();
                this.repaintArea(canvas);
            }
        } else if (ch == '\u001b' && !selected.isEmpty()) {
            selected.clearSelected();
            this.repaintArea(canvas);
        }
    }

    @Override
    public void mouseDragged(Canvas canvas, MouseEvent e) {
        this.setMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
    }

    @Override
    public void mousePressed(Canvas canvas, MouseEvent e) {
        boolean shiftPressed;
        this.beforePressSelection = new ArrayList<CanvasObject>(canvas.getSelection().getSelected());
        this.beforePressHandle = canvas.getSelection().getSelectedHandle();
        int mx = e.getX();
        int my = e.getY();
        this.dragStart = Location.create(mx, my, false);
        this.dragEffective = false;
        this.dragEnd = this.dragStart;
        this.lastMouseX = mx;
        this.lastMouseY = my;
        Selection selection = canvas.getSelection();
        selection.setHandleSelected(null);
        int halfSize = this.getHandleSize(canvas) / 2;
        CanvasObject clicked = null;
        for (CanvasObject shape : selection.getSelected()) {
            List<Handle> handles = shape.getHandles(null);
            for (Handle han : handles) {
                int dx = han.getX() - mx;
                int dy = han.getY() - my;
                if (dx < -halfSize || dx > halfSize || dy < -halfSize || dy > halfSize) continue;
                if (shape.canMoveHandle(han)) {
                    this.curAction = 4;
                    this.curGesture = new HandleGesture(han, 0, 0, e.getModifiersEx());
                    this.repaintArea(canvas);
                    return;
                }
                if (clicked != null) continue;
                clicked = shape;
            }
        }
        if (clicked == null) {
            clicked = SelectTool.getObjectAt(canvas.getModel(), e.getX(), e.getY(), false);
        }
        boolean bl = shiftPressed = (e.getModifiersEx() & 0x40) != 0;
        if (clicked != null) {
            if (shiftPressed && selection.isSelected(clicked)) {
                selection.setSelected(clicked, false);
                this.curAction = 0;
            } else {
                if (!shiftPressed && !selection.isSelected(clicked)) {
                    selection.clearSelected();
                }
                selection.setSelected(clicked, true);
                selection.setMovingShapes(selection.getSelected(), 0, 0);
                this.curAction = 1;
            }
            this.repaintArea(canvas);
            return;
        }
        clicked = SelectTool.getObjectAt(canvas.getModel(), e.getX(), e.getY(), true);
        if (clicked != null && selection.isSelected(clicked)) {
            if (shiftPressed) {
                selection.setSelected(clicked, false);
                this.curAction = 0;
            } else {
                selection.setMovingShapes(selection.getSelected(), 0, 0);
                this.curAction = 1;
            }
            this.repaintArea(canvas);
            return;
        }
        if (shiftPressed) {
            this.curAction = 3;
        } else {
            selection.clearSelected();
            this.curAction = 2;
        }
        this.repaintArea(canvas);
    }

    @Override
    public void mouseReleased(Canvas canvas, MouseEvent e) {
        Location loc;
        CanvasObject o;
        this.beforePressSelection = null;
        this.beforePressHandle = null;
        this.setMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
        CanvasModel model = canvas.getModel();
        Selection selection = canvas.getSelection();
        Set<CanvasObject> selected = selection.getSelected();
        int action = this.curAction;
        this.curAction = 0;
        if (!this.dragEffective && (o = SelectTool.getObjectAt(model, (loc = this.dragEnd).getX(), loc.getY(), false)) != null) {
            Handle han = o.canDeleteHandle(loc);
            if (han != null) {
                selection.setHandleSelected(han);
            } else {
                han = o.canInsertHandle(loc);
                if (han != null) {
                    selection.setHandleSelected(han);
                }
            }
        }
        Location start = this.dragStart;
        int x1 = e.getX();
        int y1 = e.getY();
        switch (action) {
            case 1: {
                Location moveDelta = selection.getMovingDelta();
                if (!this.dragEffective || moveDelta.equals(Location.create(0, 0, false))) break;
                canvas.doAction(new ModelTranslateAction(model, selected, moveDelta.getX(), moveDelta.getY()));
                break;
            }
            case 4: {
                HandleGesture gesture = this.curGesture;
                this.curGesture = null;
                if (!this.dragEffective || gesture == null) break;
                ModelMoveHandleAction act = new ModelMoveHandleAction(model, gesture);
                canvas.doAction(act);
                Handle result = act.getNewHandle();
                if (result == null) break;
                selection.setHandleSelected(result.getObject().canDeleteHandle(result.getLocation()));
                break;
            }
            case 2: {
                if (this.dragEffective) {
                    Bounds bds = Bounds.create(start).add(x1, y1);
                    selection.setSelected(canvas.getModel().getObjectsIn(bds), true);
                    break;
                }
                CanvasObject clicked = SelectTool.getObjectAt(model, start.getX(), start.getY(), true);
                if (clicked == null) break;
                selection.clearSelected();
                selection.setSelected(clicked, true);
                break;
            }
            case 3: {
                if (this.dragEffective) {
                    Bounds bds = Bounds.create(start).add(x1, y1);
                    selection.toggleSelected(canvas.getModel().getObjectsIn(bds));
                    break;
                }
                CanvasObject clicked = SelectTool.getObjectAt(model, start.getX(), start.getY(), true);
                if (clicked == null) break;
                selection.setSelected(clicked, !selected.contains(clicked));
                break;
            }
        }
        selection.clearDrawsSuppressed();
        this.repaintArea(canvas);
    }

    private void repaintArea(Canvas canvas) {
        canvas.repaint();
    }

    private void setMouse(Canvas canvas, int mx, int my, int mods) {
        Location newEnd;
        this.lastMouseX = mx;
        this.lastMouseY = my;
        this.dragEnd = newEnd = Location.create(mx, my, false);
        Location start = this.dragStart;
        int dx = newEnd.getX() - start.getX();
        int dy = newEnd.getY() - start.getY();
        if (!this.dragEffective) {
            if (Math.abs(dx) + Math.abs(dy) > 2) {
                this.dragEffective = true;
            } else {
                return;
            }
        }
        boolean shiftPressed = (mods & 0x40) != 0;
        boolean ctrlPressed = (mods & 0x80) != 0;
        switch (this.curAction) {
            case 4: {
                HandleGesture gesture = this.curGesture;
                if (ctrlPressed) {
                    Handle h = gesture.getHandle();
                    dx = canvas.snapX(h.getX() + dx) - h.getX();
                    dy = canvas.snapY(h.getY() + dy) - h.getY();
                }
                this.curGesture = new HandleGesture(gesture.getHandle(), dx, dy, mods);
                canvas.getSelection().setHandleGesture(this.curGesture);
                break;
            }
            case 1: {
                if (ctrlPressed) {
                    int minX = Integer.MAX_VALUE;
                    int minY = Integer.MAX_VALUE;
                    for (CanvasObject o : canvas.getSelection().getSelected()) {
                        for (Handle handle : o.getHandles(null)) {
                            int x = handle.getX();
                            int y = handle.getY();
                            if (x < minX) {
                                minX = x;
                            }
                            if (y >= minY) continue;
                            minY = y;
                        }
                    }
                    dx = canvas.snapX(minX + dx) - minX;
                    dy = canvas.snapY(minY + dy) - minY;
                }
                if (shiftPressed) {
                    if (Math.abs(dx) > Math.abs(dy)) {
                        dy = 0;
                    } else {
                        dx = 0;
                    }
                }
                canvas.getSelection().setMovingDelta(dx, dy);
                break;
            }
        }
        this.repaintArea(canvas);
    }

    @Override
    public void toolDeselected(Canvas canvas) {
        this.curAction = 0;
        canvas.getSelection().clearSelected();
        this.repaintArea(canvas);
    }

    @Override
    public void toolSelected(Canvas canvas) {
        this.curAction = 0;
        canvas.getSelection().clearSelected();
        this.repaintArea(canvas);
    }
}

