/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.tools;

import com.cburch.draw.actions.ModelAddAction;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.icons.DrawCurveIcon;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.shapes.Curve;
import com.cburch.draw.shapes.CurveUtil;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.LineUtil;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.draw.tools.DrawingAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Location;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;

public class CurveTool
extends AbstractTool {
    private static final int BEFORE_CREATION = 0;
    private static final int ENDPOINT_DRAG = 1;
    private static final int CONTROL_DRAG = 2;
    private final DrawingAttributeSet attrs;
    private int state;
    private Location end0;
    private Location end1;
    private Curve curCurve;
    private boolean mouseDown;
    private int lastMouseX;
    private int lastMouseY;

    public CurveTool(DrawingAttributeSet attrs) {
        this.attrs = attrs;
        this.state = 0;
        this.mouseDown = false;
    }

    @Override
    public void draw(Canvas canvas, Graphics gfx) {
        gfx.setColor(Color.GRAY);
        switch (this.state) {
            case 1: {
                gfx.drawLine(this.end0.getX(), this.end0.getY(), this.end1.getX(), this.end1.getY());
                break;
            }
            case 2: {
                ((Graphics2D)gfx).draw(this.curCurve.getCurve2D());
                break;
            }
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.getFillAttributes(this.attrs.getValue(DrawAttr.PAINT_TYPE));
    }

    @Override
    public Cursor getCursor(Canvas canvas) {
        return Cursor.getPredefinedCursor(1);
    }

    @Override
    public Icon getIcon() {
        return new DrawCurveIcon();
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        int code = e.getKeyCode();
        if (this.mouseDown && (code == 16 || code == 17 || code == 18)) {
            this.updateMouse(canvas, this.lastMouseX, this.lastMouseY, e.getModifiersEx());
            this.repaintArea(canvas);
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        this.keyPressed(canvas, e);
    }

    @Override
    public void keyTyped(Canvas canvas, KeyEvent e) {
        if (e.getKeyChar() == '\u001b') {
            this.state = 0;
            this.repaintArea(canvas);
            canvas.toolGestureComplete(this, null);
        }
    }

    @Override
    public void mouseDragged(Canvas canvas, MouseEvent e) {
        this.updateMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
        this.repaintArea(canvas);
    }

    @Override
    public void mousePressed(Canvas canvas, MouseEvent e) {
        int mx = e.getX();
        int my = e.getY();
        this.lastMouseX = mx;
        this.lastMouseY = my;
        this.mouseDown = true;
        int mods = e.getModifiersEx();
        if ((mods & 0x80) != 0) {
            mx = canvas.snapX(mx);
            my = canvas.snapY(my);
        }
        switch (this.state) {
            case 0: 
            case 2: {
                this.end1 = this.end0 = Location.create(mx, my, false);
                this.state = 1;
                break;
            }
            case 1: {
                this.curCurve = new Curve(this.end0, this.end1, Location.create(mx, my, false));
                this.state = 2;
                break;
            }
        }
        this.repaintArea(canvas);
    }

    @Override
    public void mouseReleased(Canvas canvas, MouseEvent e) {
        Curve c = this.updateMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
        this.mouseDown = false;
        if (this.state == 2) {
            if (c != null) {
                this.attrs.applyTo(c);
                CanvasModel model = canvas.getModel();
                canvas.doAction(new ModelAddAction(model, c));
                canvas.toolGestureComplete(this, c);
            }
            this.state = 0;
        }
        this.repaintArea(canvas);
    }

    private void repaintArea(Canvas canvas) {
        canvas.repaint();
    }

    @Override
    public void toolDeselected(Canvas canvas) {
        this.state = 0;
        this.repaintArea(canvas);
    }

    private Curve updateMouse(Canvas canvas, int mx, int my, int mods) {
        this.lastMouseX = mx;
        this.lastMouseY = my;
        boolean shiftDown = (mods & 0x40) != 0;
        boolean ctrlDown = (mods & 0x80) != 0;
        boolean altDown = (mods & 0x200) != 0;
        Curve ret = null;
        switch (this.state) {
            case 1: {
                if (!this.mouseDown) break;
                if (shiftDown) {
                    Location p = LineUtil.snapTo8Cardinals(this.end0, mx, my);
                    mx = p.getX();
                    my = p.getY();
                }
                if (ctrlDown) {
                    mx = canvas.snapX(mx);
                    my = canvas.snapY(my);
                }
                this.end1 = Location.create(mx, my, false);
                break;
            }
            case 2: {
                if (!this.mouseDown) break;
                int cx = mx;
                int cy = my;
                if (ctrlDown) {
                    cx = canvas.snapX(cx);
                    cy = canvas.snapY(cy);
                }
                if (shiftDown) {
                    double x0 = this.end0.getX();
                    double y0 = this.end0.getY();
                    double x1 = this.end1.getX();
                    double y1 = this.end1.getY();
                    double midx = (x0 + x1) / 2.0;
                    double midy = (y0 + y1) / 2.0;
                    double dx = x1 - x0;
                    double dy = y1 - y0;
                    double[] p = LineUtil.nearestPointInfinite(cx, cy, midx, midy, midx - dy, midy + dx);
                    cx = (int)Math.round(p[0]);
                    cy = (int)Math.round(p[1]);
                }
                if (altDown) {
                    double[] e0 = new double[]{this.end0.getX(), this.end0.getY()};
                    double[] e1 = new double[]{this.end1.getX(), this.end1.getY()};
                    double[] mid = new double[]{cx, cy};
                    double[] ct = CurveUtil.interpolate(e0, e1, mid);
                    cx = (int)Math.round(ct[0]);
                    cy = (int)Math.round(ct[1]);
                }
                this.curCurve = ret = new Curve(this.end0, this.end1, Location.create(cx, cy, false));
                break;
            }
        }
        return ret;
    }
}

