/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.Strings;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Rectangular;
import com.cburch.draw.shapes.SvgCreator;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import java.awt.Graphics;
import java.util.List;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rectangle
extends Rectangular {
    public Rectangle(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    @Override
    protected boolean contains(int x, int y, int w, int h, Location q) {
        return this.isInRect(q.getX(), q.getY(), x, y, w, h);
    }

    @Override
    public void draw(Graphics g, int x, int y, int w, int h) {
        if (this.setForFill(g)) {
            g.fillRect(x, y, w, h);
        }
        if (this.setForStroke(g)) {
            g.drawRect(x, y, w, h);
        }
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.getFillAttributes(this.getPaintType());
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("shapeRect");
    }

    @Override
    protected Location getRandomPoint(Bounds bds, Random rand) {
        if (this.getPaintType() != DrawAttr.PAINT_STROKE) {
            return super.getRandomPoint(bds, rand);
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int u = rand.nextInt(2 * w + 2 * h);
        int x = this.getX();
        int y = this.getY();
        if (u < w) {
            x += u;
        } else if (u < 2 * w) {
            x += u - w;
            y += h;
        } else if (u < 2 * w + h) {
            y += u - 2 * w;
        } else {
            x += w;
            y += u - 2 * w - h;
        }
        int d = this.getStrokeWidth();
        if (d > 1) {
            x += rand.nextInt(d) - d / 2;
            y += rand.nextInt(d) - d / 2;
        }
        return Location.create(x, y, false);
    }

    @Override
    public boolean matches(CanvasObject other) {
        return other instanceof Rectangle && super.matches(other);
    }

    public String toString() {
        return "Rectangle:" + String.valueOf(this.getBounds());
    }

    @Override
    public Element toSvgElement(Document doc) {
        return SvgCreator.createRectangle(doc, this);
    }
}

