/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.logisim.data.Location;

public final class LineUtil {
    private static final double zeroMax = 1.0E-7;

    private LineUtil() {
    }

    public static double distance(double x0, double y0, double x1, double y1) {
        return Math.sqrt(LineUtil.distanceSquared(x0, y0, x1, y1));
    }

    public static double distanceSquared(double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        return dx * dx + dy * dy;
    }

    private static double[] nearestPoint(double xq, double yq, double x0, double y0, double x1, double y1, boolean isSegment) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double len2 = dx * dx + dy * dy;
        if (len2 < 9.999999999999998E-15) {
            return new double[]{(x0 + x1) / 2.0, (y0 + y1) / 2.0};
        }
        double num = (xq - x0) * dx + (yq - y0) * dy;
        double u = isSegment ? (num < 0.0 ? 0.0 : (num < len2 ? num / len2 : 1.0)) : num / len2;
        return new double[]{x0 + u * dx, y0 + u * dy};
    }

    public static double[] nearestPointInfinite(double xq, double yq, double x0, double y0, double x1, double y1) {
        return LineUtil.nearestPoint(xq, yq, x0, y0, x1, y1, false);
    }

    public static double[] nearestPointSegment(double xq, double yq, double x0, double y0, double x1, double y1) {
        return LineUtil.nearestPoint(xq, yq, x0, y0, x1, y1, true);
    }

    public static double ptDistSqSegment(double x0, double y0, double x1, double y1, double xq, double yq) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double len2 = dx * dx + dy * dy;
        if (len2 < 9.999999999999998E-15) {
            return LineUtil.distanceSquared(xq, yq, (x0 + x1) / 2.0, (y0 + y1) / 2.0);
        }
        double u = ((xq - x0) * dx + (yq - y0) * dy) / len2;
        if (u <= 0.0) {
            return LineUtil.distanceSquared(xq, yq, x0, y0);
        }
        if (u >= 1.0) {
            return LineUtil.distanceSquared(xq, yq, x1, y1);
        }
        return LineUtil.distanceSquared(xq, yq, x0 + u * dx, y0 + u * dy);
    }

    public static Location snapTo8Cardinals(Location from, int mx, int my) {
        int px = from.getX();
        int py = from.getY();
        if (mx != px && my != py) {
            double ang = Math.atan2(my - py, mx - px);
            int d45 = (Math.abs(mx - px) + Math.abs(my - py)) / 2;
            int d = (int)(4.0 * ang / Math.PI + 4.5);
            switch (d) {
                case 0: 
                case 4: 
                case 8: {
                    return Location.create(mx, py, false);
                }
                case 2: 
                case 6: {
                    return Location.create(px, my, false);
                }
                case 1: {
                    return Location.create(px - d45, py - d45, false);
                }
                case 3: {
                    return Location.create(px + d45, py - d45, false);
                }
                case 5: {
                    return Location.create(px + d45, py + d45, false);
                }
                case 7: {
                    return Location.create(px - d45, py + d45, false);
                }
            }
        }
        return Location.create(mx, my, false);
    }
}

