/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import java.awt.Color;

abstract class FillableCanvasObject
extends AbstractCanvasObject {
    private AttributeOption paintType = DrawAttr.PAINT_STROKE;
    private int strokeWidth = 1;
    private Color strokeColor = Color.BLACK;
    private Color fillColor = Color.WHITE;

    public AttributeOption getPaintType() {
        return this.paintType;
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == DrawAttr.PAINT_TYPE) {
            return (V)this.paintType;
        }
        if (attr == DrawAttr.STROKE_COLOR) {
            return (V)this.strokeColor;
        }
        if (attr == DrawAttr.FILL_COLOR) {
            return (V)this.fillColor;
        }
        if (attr == DrawAttr.STROKE_WIDTH) {
            return (V)Integer.valueOf(this.strokeWidth);
        }
        return null;
    }

    @Override
    public boolean matches(CanvasObject other) {
        boolean ret;
        if (!(other instanceof FillableCanvasObject)) {
            return false;
        }
        FillableCanvasObject that = (FillableCanvasObject)other;
        boolean bl = ret = this.paintType == that.paintType;
        if (ret && this.paintType != DrawAttr.PAINT_FILL) {
            boolean bl2 = ret = ret && this.strokeWidth == that.strokeWidth && this.strokeColor.equals(that.strokeColor);
        }
        if (ret && this.paintType != DrawAttr.PAINT_STROKE) {
            ret = ret && this.fillColor.equals(that.fillColor);
        }
        return ret;
    }

    @Override
    public int matchesHashCode() {
        int ret = this.paintType.hashCode();
        if (this.paintType != DrawAttr.PAINT_FILL) {
            ret = ret * 31 + this.strokeWidth;
            ret = ret * 31 + this.strokeColor.hashCode();
        } else {
            ret = ret * 31 * 31;
        }
        ret = this.paintType != DrawAttr.PAINT_STROKE ? ret * 31 + this.fillColor.hashCode() : (ret *= 31);
        return ret;
    }

    @Override
    public void updateValue(Attribute<?> attr, Object value) {
        if (attr == DrawAttr.PAINT_TYPE) {
            this.paintType = (AttributeOption)value;
            this.fireAttributeListChanged();
        } else if (attr == DrawAttr.STROKE_COLOR) {
            this.strokeColor = (Color)value;
        } else if (attr == DrawAttr.FILL_COLOR) {
            this.fillColor = (Color)value;
        } else if (attr == DrawAttr.STROKE_WIDTH) {
            this.strokeWidth = (Integer)value;
        }
    }
}

