/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.shapes;

import com.cburch.logisim.data.Bounds;

public final class CurveUtil {
    private static final double zeroMax = 1.0E-7;

    private CurveUtil() {
    }

    private static double[] computeA(double[] p0, double[] p1) {
        return new double[]{p1[0] - p0[0], p1[1] - p0[1]};
    }

    private static double[] computeB(double[] p0, double[] p1, double[] p2) {
        return new double[]{p0[0] - 2.0 * p1[0] + p2[0], p0[1] - 2.0 * p1[1] + p2[1]};
    }

    public static double[] findNearestPoint(double[] q, double[] p0, double[] p1, double[] p2) {
        double d;
        double[] pos;
        double c;
        double b;
        double[] A = CurveUtil.computeA(p0, p1);
        double[] B = CurveUtil.computeB(p0, p1, p2);
        double a = B[0] * B[0] + B[1] * B[1];
        double[] roots = CurveUtil.solveCubic(a, b = 3.0 * (A[0] * B[0] + A[1] * B[1]), c = 2.0 * (A[0] * A[0] + A[1] * A[1]) + (pos = new double[]{p0[0] - q[0], p0[1] - q[1]})[0] * B[0] + pos[1] * B[1], d = pos[0] * A[0] + pos[1] * A[1]);
        if (roots == null) {
            return null;
        }
        double tMin = Double.MAX_VALUE;
        double dist2Min = Double.MAX_VALUE;
        double[] posMin = new double[2];
        for (double root : roots) {
            double t = root < 0.0 ? 0.0 : (root <= 1.0 ? root : 1.0);
            CurveUtil.getPos(pos, t, p0, p1, p2);
            double lx = q[0] - pos[0];
            double ly = q[1] - pos[1];
            double dist2 = lx * lx + ly * ly;
            if (!(dist2 < dist2Min)) continue;
            tMin = root;
            dist2Min = dist2;
            posMin[0] = pos[0];
            posMin[1] = pos[1];
        }
        return tMin == Double.MAX_VALUE ? null : posMin;
    }

    public static Bounds getBounds(double[] p0, double[] p1, double[] p2) {
        double u;
        double[] A = CurveUtil.computeA(p0, p1);
        double[] B = CurveUtil.computeB(p0, p1, p2);
        double xMin = Math.min(p0[0], Math.min(p1[0], p2[0]));
        double xMax = Math.max(p0[0], Math.max(p1[0], p2[0]));
        double yMin = Math.min(p0[1], Math.min(p1[1], p2[1]));
        double yMax = Math.max(p0[1], Math.max(p1[1], p2[1]));
        if (xMin == p1[0] || xMax == p1[0]) {
            u = -A[0] / B[0];
            u = (1.0 - u) * (1.0 - u) * p0[0] + 2.0 * u * (1.0 - u) * p1[0] + u * u * p2[0];
            if (xMin == p1[0]) {
                xMin = u;
            } else {
                xMax = u;
            }
        }
        if (yMin == p1[1] || yMax == p1[1]) {
            u = -A[1] / B[1];
            u = (1.0 - u) * (1.0 - u) * p0[1] + 2.0 * u * (1.0 - u) * p1[1] + u * u * p2[1];
            if (yMin == p1[1]) {
                yMin = u;
            } else {
                yMax = u;
            }
        }
        int x = (int)xMin;
        int y = (int)yMin;
        int w = (int)Math.ceil(xMax) - x;
        int h = (int)Math.ceil(yMax) - y;
        return Bounds.create(x, y, w, h);
    }

    private static void getPos(double[] result, double t, double[] p0, double[] p1, double[] p2) {
        double a = (1.0 - t) * (1.0 - t);
        double b = 2.0 * t * (1.0 - t);
        double c = t * t;
        result[0] = a * p0[0] + b * p1[0] + c * p2[0];
        result[1] = a * p0[1] + b * p1[1] + c * p2[1];
    }

    public static double[] interpolate(double[] end0, double[] end1, double[] mid) {
        double dx = mid[0] - end0[0];
        double dy = mid[1] - end0[1];
        double d0 = Math.sqrt(dx * dx + dy * dy);
        dx = mid[0] - end1[0];
        dy = mid[1] - end1[1];
        double d1 = Math.sqrt(dx * dx + dy * dy);
        if (d0 < 1.0E-7 || d1 < 1.0E-7) {
            return new double[]{(end0[0] + end1[0]) / 2.0, (end0[1] + end1[1]) / 2.0};
        }
        double t = d0 / (d0 + d1);
        double u = 1.0 - t;
        double t2 = t * t;
        double u2 = u * u;
        double den = 2.0 * t * u;
        double xNum = mid[0] - u2 * end0[0] - t2 * end1[0];
        double yNum = mid[1] - u2 * end0[1] - t2 * end1[1];
        return new double[]{xNum / den, yNum / den};
    }

    private static double[] solveCubic(double a, double b, double c, double d) {
        if (Math.abs(a) > 1.0E-7) {
            double z = a;
            a = b / z;
            b = c / z;
            c = d / z;
            double p = b - a * a / 3.0;
            double q = a * (2.0 * a * a - 9.0 * b) / 27.0 + c;
            double p3 = p * p * p;
            double D = q * q + 4.0 * p3 / 27.0;
            double offset = -a / 3.0;
            if (D > 1.0E-7) {
                z = Math.sqrt(D);
                double u = (-q + z) / 2.0;
                double v = (-q - z) / 2.0;
                u = u >= 0.0 ? Math.pow(u, 0.3333333333333333) : -Math.pow(-u, 0.3333333333333333);
                v = v >= 0.0 ? Math.pow(v, 0.3333333333333333) : -Math.pow(-v, 0.3333333333333333);
                return new double[]{u + v + offset};
            }
            if (D < -1.0E-7) {
                double u = 2.0 * Math.sqrt(-p / 3.0);
                double v = Math.acos(-Math.sqrt(-27.0 / p3) * q / 2.0) / 3.0;
                return new double[]{u * Math.cos(v) + offset, u * Math.cos(v + 2.0943951023931953) + offset, u * Math.cos(v + 4.1887902047863905) + offset};
            }
            double u = q < 0.0 ? Math.pow(-q / 2.0, 0.3333333333333333) : -Math.pow(q / 2.0, 0.3333333333333333);
            return new double[]{2.0 * u + offset, -u + offset};
        }
        if (Math.abs(b) > 1.0E-7) {
            b = c;
            a = b;
            double D = b * b - 4.0 * a * (c = d);
            if (D <= -1.0E-7) {
                return null;
            }
            if (D > 1.0E-7) {
                D = Math.sqrt(D);
                return new double[]{(-b - D) / (2.0 * a), (-b + D) / (2.0 * a)};
            }
            return new double[]{-b / (2.0 * a)};
        }
        if (Math.abs(c) > 1.0E-7) {
            return new double[]{-d / c};
        }
        return null;
    }
}

