/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.model;

import com.cburch.draw.model.AttributeMapKey;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.model.ReorderRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class CanvasModelEvent
extends EventObject {
    public static final int ACTION_ADDED = 0;
    public static final int ACTION_REMOVED = 1;
    public static final int ACTION_TRANSLATED = 2;
    public static final int ACTION_REORDERED = 3;
    public static final int ACTION_HANDLE_MOVED = 4;
    public static final int ACTION_HANDLE_INSERTED = 5;
    public static final int ACTION_HANDLE_DELETED = 6;
    public static final int ACTION_ATTRIBUTES_CHANGED = 7;
    public static final int ACTION_TEXT_CHANGED = 8;
    private static final long serialVersionUID = 1L;
    private final int action;
    private Collection<? extends CanvasObject> affected;
    private int deltaX;
    private int deltaY;
    private Map<AttributeMapKey, Object> oldValues;
    private Map<AttributeMapKey, Object> newValues;
    private Collection<ReorderRequest> reorderRequests;
    private Handle handle;
    private HandleGesture gesture;
    private String oldText;
    private String newText;

    private CanvasModelEvent(boolean dummy2, CanvasModel source, int action, Collection<ReorderRequest> requests) {
        this(source, action, Collections.emptySet());
        ArrayList<? extends CanvasObject> affected = new ArrayList<CanvasObject>(requests.size());
        for (ReorderRequest r : requests) {
            affected.add(r.getObject());
        }
        this.affected = affected;
        this.reorderRequests = Collections.unmodifiableCollection(requests);
    }

    private CanvasModelEvent(CanvasModel source, int action, Collection<? extends CanvasObject> affected) {
        super(source);
        this.action = action;
        this.affected = affected;
        this.deltaX = 0;
        this.deltaY = 0;
        this.oldValues = null;
        this.newValues = null;
        this.reorderRequests = null;
        this.handle = null;
        this.gesture = null;
        this.oldText = null;
        this.newText = null;
    }

    private CanvasModelEvent(CanvasModel source, int action, Collection<? extends CanvasObject> affected, int dx, int dy) {
        this(source, action, affected);
        this.deltaX = dx;
        this.deltaY = dy;
    }

    private CanvasModelEvent(CanvasModel source, int action, Collection<? extends CanvasObject> affected, String oldText, String newText) {
        this(source, action, affected);
        this.oldText = oldText;
        this.newText = newText;
    }

    private CanvasModelEvent(CanvasModel source, int action, Handle handle) {
        this(source, action, Collections.singleton(handle.getObject()));
        this.handle = handle;
    }

    private CanvasModelEvent(CanvasModel source, int action, HandleGesture gesture) {
        this(source, action, gesture.getHandle());
        this.gesture = gesture;
    }

    private CanvasModelEvent(CanvasModel source, int action, Map<AttributeMapKey, Object> oldValues, Map<AttributeMapKey, Object> newValues) {
        this(source, action, Collections.emptySet());
        HashSet<? extends CanvasObject> affected = new HashSet<CanvasObject>(newValues.size());
        for (AttributeMapKey key : newValues.keySet()) {
            affected.add(key.getObject());
        }
        this.affected = affected;
        HashMap<AttributeMapKey, Object> oldValuesCopy = new HashMap<AttributeMapKey, Object>(oldValues);
        HashMap<AttributeMapKey, Object> newValuesCopy = new HashMap<AttributeMapKey, Object>(newValues);
        this.oldValues = Collections.unmodifiableMap(oldValuesCopy);
        this.newValues = Collections.unmodifiableMap(newValuesCopy);
    }

    public static CanvasModelEvent forAdd(CanvasModel source, Collection<? extends CanvasObject> affected) {
        return new CanvasModelEvent(source, 0, affected);
    }

    public static CanvasModelEvent forChangeAttributes(CanvasModel source, Map<AttributeMapKey, Object> oldValues, Map<AttributeMapKey, Object> newValues) {
        return new CanvasModelEvent(source, 7, oldValues, newValues);
    }

    public static CanvasModelEvent forChangeText(CanvasModel source, CanvasObject obj, String oldText, String newText) {
        return new CanvasModelEvent(source, 8, Collections.singleton(obj), oldText, newText);
    }

    public static CanvasModelEvent forDeleteHandle(CanvasModel source, Handle handle) {
        return new CanvasModelEvent(source, 6, handle);
    }

    public static CanvasModelEvent forInsertHandle(CanvasModel source, Handle desired) {
        return new CanvasModelEvent(source, 5, desired);
    }

    public static CanvasModelEvent forMoveHandle(CanvasModel source, HandleGesture gesture) {
        return new CanvasModelEvent(source, 4, gesture);
    }

    public static CanvasModelEvent forRemove(CanvasModel source, Collection<? extends CanvasObject> affected) {
        return new CanvasModelEvent(source, 1, affected);
    }

    public static CanvasModelEvent forReorder(CanvasModel source, Collection<ReorderRequest> requests) {
        return new CanvasModelEvent(true, source, 3, requests);
    }

    public static CanvasModelEvent forTranslate(CanvasModel source, Collection<? extends CanvasObject> affected) {
        return new CanvasModelEvent(source, 2, affected, 0, 0);
    }

    public int getAction() {
        return this.action;
    }

    public Collection<? extends CanvasObject> getAffected() {
        Map<AttributeMapKey, Object> newVals;
        Collection<CanvasObject> ret = this.affected;
        if (ret == null && (newVals = this.newValues) != null) {
            HashSet<CanvasObject> keys = new HashSet<CanvasObject>();
            for (AttributeMapKey key : newVals.keySet()) {
                keys.add(key.getObject());
            }
            this.affected = ret = Collections.unmodifiableCollection(keys);
        }
        return this.affected;
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public HandleGesture getHandleGesture() {
        return this.gesture;
    }

    public String getNewText() {
        return this.newText;
    }

    public Map<AttributeMapKey, Object> getNewValues() {
        return this.newValues;
    }

    public String getOldText() {
        return this.oldText;
    }

    public Map<AttributeMapKey, Object> getOldValues() {
        return this.oldValues;
    }

    public Collection<ReorderRequest> getReorderRequests() {
        return this.reorderRequests;
    }
}

