/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.canvas;

import com.cburch.draw.canvas.SelectionEvent;
import com.cburch.draw.canvas.SelectionListener;
import com.cburch.draw.model.CanvasModelEvent;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.logisim.data.Location;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Selection {
    private static final String MOVING_HANDLE = "movingHandle";
    private static final String TRANSLATING = "translating";
    private static final String HIDDEN = "hidden";
    private final List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    private final Set<CanvasObject> selected = new HashSet<CanvasObject>();
    private final Set<CanvasObject> selectedView;
    private final Map<CanvasObject, String> suppressed = new HashMap<CanvasObject, String>();
    private final Set<CanvasObject> suppressedView;
    private Handle selectedHandle;
    private HandleGesture curHandleGesture;
    private int moveDx;
    private int moveDy;

    protected Selection() {
        this.selectedView = Collections.unmodifiableSet(this.selected);
        this.suppressedView = Collections.unmodifiableSet(this.suppressed.keySet());
    }

    public void addSelectionListener(SelectionListener l) {
        this.listeners.add(l);
    }

    public void clearDrawsSuppressed() {
        this.suppressed.clear();
        this.curHandleGesture = null;
    }

    public void clearSelected() {
        if (!this.selected.isEmpty()) {
            ArrayList<CanvasObject> oldSelected = new ArrayList<CanvasObject>(this.selected);
            this.selected.clear();
            this.suppressed.clear();
            this.setHandleSelected(null);
            this.fireChanged(1, oldSelected);
        }
    }

    public void drawSuppressed(Graphics g, CanvasObject shape) {
        String state = this.suppressed.get(shape);
        if (state.equals(MOVING_HANDLE)) {
            shape.paint(g, this.curHandleGesture);
        } else if (state.equals(TRANSLATING)) {
            g.translate(this.moveDx, this.moveDy);
            shape.paint(g, null);
        }
    }

    private void fireChanged(int action, Collection<CanvasObject> affected) {
        SelectionEvent e = null;
        for (SelectionListener listener : this.listeners) {
            if (e == null) {
                e = new SelectionEvent(this, action, affected);
            }
            listener.selectionChanged(e);
        }
    }

    public Set<CanvasObject> getDrawsSuppressed() {
        return this.suppressedView;
    }

    public Location getMovingDelta() {
        return Location.create(this.moveDx, this.moveDy, false);
    }

    public Set<CanvasObject> getSelected() {
        return this.selectedView;
    }

    public Handle getSelectedHandle() {
        return this.selectedHandle;
    }

    public boolean isEmpty() {
        return this.selected.isEmpty();
    }

    public boolean isSelected(CanvasObject shape) {
        return this.selected.contains(shape);
    }

    void modelChanged(CanvasModelEvent event) {
        switch (event.getAction()) {
            case 1: {
                Collection<? extends CanvasObject> affected = event.getAffected();
                if (affected == null) break;
                this.selected.removeAll(affected);
                this.suppressed.keySet().removeAll(affected);
                Handle handle = this.selectedHandle;
                if (handle == null || !affected.contains(handle.getObject())) break;
                this.setHandleSelected(null);
                break;
            }
            case 6: {
                if (!event.getHandle().equals(this.selectedHandle)) break;
                this.setHandleSelected(null);
                break;
            }
            case 4: {
                HandleGesture gesture = event.getHandleGesture();
                if (!gesture.getHandle().equals(this.selectedHandle)) break;
                this.setHandleSelected(gesture.getResultingHandle());
                break;
            }
        }
    }

    public void removeSelectionListener(SelectionListener l) {
        this.listeners.remove(l);
    }

    public void setHandleGesture(HandleGesture gesture) {
        HandleGesture g = this.curHandleGesture;
        if (g != null) {
            this.suppressed.remove(g.getHandle().getObject());
        }
        Handle h = gesture.getHandle();
        this.suppressed.put(h.getObject(), MOVING_HANDLE);
        this.curHandleGesture = gesture;
    }

    public void setHandleSelected(Handle handle) {
        Handle cur = this.selectedHandle;
        boolean same = Objects.equals(cur, handle);
        if (!same) {
            this.selectedHandle = handle;
            this.curHandleGesture = null;
            Set<CanvasObject> objs = handle == null ? Collections.emptySet() : Collections.singleton(handle.getObject());
            this.fireChanged(2, objs);
        }
    }

    public void setHidden(Collection<? extends CanvasObject> shapes, boolean value) {
        if (value) {
            for (CanvasObject canvasObject : shapes) {
                this.suppressed.put(canvasObject, HIDDEN);
            }
        } else {
            this.suppressed.keySet().removeAll(shapes);
        }
    }

    public void setMovingDelta(int dx, int dy) {
        this.moveDx = dx;
        this.moveDy = dy;
    }

    public void setMovingShapes(Collection<? extends CanvasObject> shapes, int dx, int dy) {
        for (CanvasObject canvasObject : shapes) {
            this.suppressed.put(canvasObject, TRANSLATING);
        }
        this.moveDx = dx;
        this.moveDy = dy;
    }

    public void setSelected(CanvasObject shape, boolean value) {
        this.setSelected(Collections.singleton(shape), value);
    }

    public void setSelected(Collection<CanvasObject> shapes, boolean value) {
        if (value) {
            ArrayList<CanvasObject> added = new ArrayList<CanvasObject>(shapes.size());
            for (CanvasObject shape : shapes) {
                if (!this.selected.add(shape)) continue;
                added.add(shape);
            }
            if (!added.isEmpty()) {
                this.fireChanged(0, added);
            }
        } else {
            ArrayList<CanvasObject> removed = new ArrayList<CanvasObject>(shapes.size());
            for (CanvasObject shape : shapes) {
                if (!this.selected.remove(shape)) continue;
                this.suppressed.remove(shape);
                Handle h = this.selectedHandle;
                if (h != null && h.getObject() == shape) {
                    this.setHandleSelected(null);
                }
                removed.add(shape);
            }
            if (!removed.isEmpty()) {
                this.fireChanged(1, removed);
            }
        }
    }

    public void toggleSelected(Collection<CanvasObject> shapes) {
        ArrayList<CanvasObject> added = new ArrayList<CanvasObject>(shapes.size());
        ArrayList<CanvasObject> removed = new ArrayList<CanvasObject>(shapes.size());
        for (CanvasObject shape : shapes) {
            if (this.selected.contains(shape)) {
                this.selected.remove(shape);
                this.suppressed.remove(shape);
                Handle h = this.selectedHandle;
                if (h != null && h.getObject() == shape) {
                    this.setHandleSelected(null);
                }
                removed.add(shape);
                continue;
            }
            this.selected.add(shape);
            added.add(shape);
        }
        if (!removed.isEmpty()) {
            this.fireChanged(1, removed);
        }
        if (!added.isEmpty()) {
            this.fireChanged(0, added);
        }
    }
}

