/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.actions;

import com.cburch.draw.Strings;
import com.cburch.draw.actions.ModelAction;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.Text;
import java.util.Collection;
import java.util.Collections;

public class ModelEditTextAction
extends ModelAction {
    private final Text text;
    private final String oldValue;
    private final String newValue;

    public ModelEditTextAction(CanvasModel model, Text text, String newValue) {
        super(model);
        this.text = text;
        this.oldValue = text.getText();
        this.newValue = newValue;
    }

    @Override
    void doSub(CanvasModel model) {
        model.setText(this.text, this.newValue);
    }

    @Override
    public String getName() {
        return Strings.S.get("actionEditText");
    }

    @Override
    public Collection<CanvasObject> getObjects() {
        return Collections.singleton(this.text);
    }

    @Override
    void undoSub(CanvasModel model) {
        model.setText(this.text, this.oldValue);
    }
}

