/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.actions;

import com.cburch.draw.Strings;
import com.cburch.draw.actions.ModelAction;
import com.cburch.draw.model.AttributeMapKey;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.data.Attribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;

public class ModelChangeAttributeAction
extends ModelAction {
    private final Map<AttributeMapKey, Object> oldValues;
    private final Map<AttributeMapKey, Object> newValues;
    private Attribute<?> attr;

    public ModelChangeAttributeAction(CanvasModel model, Map<AttributeMapKey, Object> oldValues, Map<AttributeMapKey, Object> newValues) {
        super(model);
        this.oldValues = oldValues;
        this.newValues = newValues;
    }

    @Override
    void doSub(CanvasModel model) {
        model.setAttributeValues(this.newValues);
    }

    @Override
    public String getName() {
        Attribute<?> a = this.attr;
        if (a == null) {
            boolean found = false;
            for (AttributeMapKey key : this.newValues.keySet()) {
                Attribute<?> at = key.getAttribute();
                if (found) {
                    if (Objects.equals(a, at)) continue;
                    a = null;
                    break;
                }
                found = true;
                a = at;
            }
            this.attr = a;
        }
        return a == null ? Strings.S.get("actionChangeAttributes") : Strings.S.get("actionChangeAttribute", a.getDisplayName());
    }

    @Override
    public Collection<CanvasObject> getObjects() {
        HashSet<CanvasObject> ret = new HashSet<CanvasObject>();
        for (AttributeMapKey key : this.newValues.keySet()) {
            ret.add(key.getObject());
        }
        return ret;
    }

    @Override
    void undoSub(CanvasModel model) {
        model.setAttributeValues(this.oldValues);
    }
}

