/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker.colorslider;

import com.bric.colorpicker.JVM;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.UIManager;

public class Painter {
    private Graphics2D graphics2D;
    private static final Color[] WHITES = new Color[]{new Color(255, 255, 255, 50), new Color(255, 255, 255, 100), new Color(255, 255, 255, 150)};
    private static final Color[] BLACKS = new Color[]{new Color(0, 0, 0, 50), new Color(0, 0, 0, 100), new Color(0, 0, 0, 150)};

    private static Color getFocusRingColor() {
        Color obj = UIManager.getColor("Focus.color");
        if (obj != null) {
            return obj;
        }
        Color focusRingColor = UIManager.getColor("focusRing");
        if (focusRingColor != null) {
            return focusRingColor;
        }
        return new Color(64, 113, 167);
    }

    public void setGraphics2D(Graphics2D graphics2D) {
        this.graphics2D = graphics2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintFocus(Shape shape, int pixelSize) {
        Color focusColor = Painter.getFocusRingColor();
        this.graphics2D = (Graphics2D)this.graphics2D.create();
        try {
            Color[] focusArray = new Color[]{new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 235 * focusColor.getAlpha() / 255), new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 130 * focusColor.getAlpha() / 255), new Color(focusColor.getRed(), focusColor.getGreen(), focusColor.getBlue(), 80 * focusColor.getAlpha() / 255)};
            if (JVM.isUsingQuartz()) {
                this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            } else {
                this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            }
            this.graphics2D.setStroke(new BasicStroke(2 * pixelSize + 1, 1, 1));
            this.graphics2D.setColor(focusArray[2]);
            this.graphics2D.draw(shape);
            if (2 * pixelSize + 1 > 0) {
                this.graphics2D.setStroke(new BasicStroke(2 * pixelSize - 2 + 1, 1, 1));
                this.graphics2D.setColor(focusArray[1]);
                this.graphics2D.draw(shape);
            }
            if (2 * pixelSize - 4 + 1 > 0) {
                this.graphics2D.setStroke(new BasicStroke(2 * pixelSize - 4 + 1, 1, 1));
                this.graphics2D.setColor(focusArray[0]);
                this.graphics2D.draw(shape);
            }
        }
        finally {
            this.graphics2D.dispose();
        }
    }

    public void drawBevel(Rectangle r) {
        this.graphics2D.setStroke(new BasicStroke(1.0f));
        this.drawColors(BLACKS, r.x, r.y + r.height, r.x + r.width, r.y + r.height, 5);
        this.drawColors(BLACKS, r.x + r.width, r.y, r.x + r.width, r.y + r.height, 3);
        this.drawColors(WHITES, r.x, r.y, r.x + r.width, r.y, 1);
        this.drawColors(WHITES, r.x, r.y, r.x, r.y + r.height, 7);
        this.graphics2D.setColor(new Color(120, 120, 120));
        this.graphics2D.drawRect(r.x, r.y, r.width, r.height);
    }

    private void drawColors(Color[] colors, int x1, int y1, int x2, int y2, int direction) {
        int numColors = colors.length;
        for (int a = 0; a < numColors; ++a) {
            this.graphics2D.setColor(colors[numColors - a - 1]);
            if (direction == 5) {
                this.graphics2D.drawLine(x1, y1 - a, x2, y2 - a);
                continue;
            }
            if (direction == 1) {
                this.graphics2D.drawLine(x1, y1 + a, x2, y2 + a);
                continue;
            }
            if (direction == 3) {
                this.graphics2D.drawLine(x1 - a, y1, x2 - a, y2);
                continue;
            }
            if (direction != 7) continue;
            this.graphics2D.drawLine(x1 + a, y1, x2 + a, y2);
        }
    }
}

