/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker;

import com.bric.colorpicker.ColorPickerMode;
import com.bric.colorpicker.colorslider.Painter;
import com.bric.colorpicker.listeners.ColorListener;
import com.bric.colorpicker.listeners.ColorListenerWrapper;
import com.bric.colorpicker.listeners.ModeListener;
import com.bric.colorpicker.listeners.RepaintFocusListener;
import com.bric.colorpicker.models.ColorModel;
import com.bric.colorpicker.models.ModeModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorPickerPanel
extends JPanel
implements ColorListener,
ModeListener {
    private static final Logger log = LoggerFactory.getLogger(ColorPickerPanel.class);
    public static final int MAX_SIZE = 325;
    private ColorPickerMode mode = ColorPickerMode.BRIGHTNESS;
    private Point point = new Point(0, 0);
    private final Collection<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private float hue = -1.0f;
    private float sat = -1.0f;
    private float bri = -1.0f;
    private int red = -1;
    private int green = -1;
    private int blue = -1;
    private final FocusListener focusListener = new RepaintFocusListener(this);
    private final BufferedImage image = new BufferedImage(325, 325, 2);
    private final Insets imagePadding = new Insets(6, 6, 6, 6);
    private final KeyListener keyListener = new ColorPickerKeyListener();
    private final int[] row = new int[325];
    private final MouseInputListener mouseListener = new ColorPickerMouseInputListener();
    private final ComponentListener componentListener = new ResizeListener();
    private final ColorListenerWrapper colorListenerWrapper;

    public ColorPickerPanel() {
        this.setMaximumSize(new Dimension(325 + this.imagePadding.left + this.imagePadding.right, 325 + this.imagePadding.top + this.imagePadding.bottom));
        this.setPreferredSize(new Dimension(243, 243));
        this.setRGB(0, 0, 0);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        this.setFocusable(true);
        this.addKeyListener(this.keyListener);
        this.addFocusListener(this.focusListener);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addComponentListener(this.componentListener);
        this.colorListenerWrapper = ColorListenerWrapper.withListener(colorModel -> this.setRGB(colorModel.getRed(), colorModel.getGreen(), colorModel.getBlue()));
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners.contains(changeListener)) {
            return;
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void fireChangeListeners() {
        if (this.changeListeners == null) {
            return;
        }
        for (ChangeListener l : this.changeListeners) {
            try {
                l.stateChanged(new ChangeEvent(this));
            }
            catch (RuntimeException e) {
                log.error("Change listener threw exception", e);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        int size = this.calculateSize();
        g2.translate(this.getWidth() / 2 - size / 2, this.getHeight() / 2 - size / 2);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RectangularShape shape = ColorPickerMode.SATURATION == this.mode || ColorPickerMode.BRIGHTNESS == this.mode ? new Ellipse2D.Float(0.0f, 0.0f, size, size) : new Rectangle(0, 0, size, size);
        Painter painter = new Painter();
        painter.setGraphics2D(g2);
        if (this.hasFocus()) {
            painter.paintFocus(shape, 3);
        }
        if (!(shape instanceof Rectangle)) {
            g2.translate(2, 2);
            g2.setColor(new Color(0, 0, 0, 20));
            g2.fill(new Ellipse2D.Float(-2.0f, -2.0f, size + 4, size + 4));
            g2.setColor(new Color(0, 0, 0, 40));
            g2.fill(new Ellipse2D.Float(-1.0f, -1.0f, size + 2, size + 2));
            g2.setColor(new Color(0, 0, 0, 80));
            g2.fill(new Ellipse2D.Float(0.0f, 0.0f, size, size));
            g2.translate(-2, -2);
        }
        g2.drawImage(this.image, 0, 0, size, size, 0, 0, size, size, null);
        g2.setStroke(new BasicStroke(1.0f));
        if (shape instanceof Rectangle) {
            Rectangle r = (Rectangle)shape;
            painter.drawBevel(r);
        } else {
            g2.setColor(new Color(0, 0, 0, 120));
            g2.draw(shape);
        }
        g2.setColor(Color.white);
        g2.setStroke(new BasicStroke(1.0f));
        g2.draw(new Ellipse2D.Float(this.point.x - 3, this.point.y - 3, 6.0f, 6.0f));
        g2.setColor(Color.black);
        g2.draw(new Ellipse2D.Float(this.point.x - 4, this.point.y - 4, 8.0f, 8.0f));
        g.translate(-this.imagePadding.left, -this.imagePadding.top);
    }

    public void setMode(ColorPickerMode mode) {
        Objects.requireNonNull(mode);
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.regenerateImage();
        this.regeneratePoint();
    }

    public void setRGB(int r, int g, int b) {
        if (0 > r || 255 < r) {
            throw new IllegalArgumentException("The red value (" + r + ") must be between [0,255].");
        }
        if (0 > g || 255 < g) {
            throw new IllegalArgumentException("The green value (" + g + ") must be between [0,255].");
        }
        if (0 > b || 255 < b) {
            throw new IllegalArgumentException("The blue value (" + b + ") must be between [0,255].");
        }
        if (this.red != r || this.green != g || this.blue != b) {
            if (ColorPickerMode.RED == this.mode || ColorPickerMode.GREEN == this.mode || ColorPickerMode.BLUE == this.mode) {
                int lastR = this.red;
                int lastG = this.green;
                int lastB = this.blue;
                this.red = r;
                this.green = g;
                this.blue = b;
                if (ColorPickerMode.RED == this.mode) {
                    if (lastR != r) {
                        this.regenerateImage();
                    }
                } else if (ColorPickerMode.GREEN == this.mode) {
                    if (lastG != g) {
                        this.regenerateImage();
                    }
                } else if (ColorPickerMode.BLUE == this.mode && lastB != b) {
                    this.regenerateImage();
                }
            } else {
                float[] hsb = new float[3];
                Color.RGBtoHSB(r, g, b, hsb);
                this.setHSB(hsb[0], hsb[1], hsb[2]);
                return;
            }
            this.regeneratePoint();
            this.repaint();
            this.fireChangeListeners();
        }
    }

    public float[] getHSB() {
        return new float[]{this.hue, this.sat, this.bri};
    }

    public int[] getRGB() {
        return new int[]{this.red, this.green, this.blue};
    }

    private float[] getHSB(Point p) {
        if (ColorPickerMode.RED == this.mode || ColorPickerMode.GREEN == this.mode || ColorPickerMode.BLUE == this.mode) {
            int[] rgb = this.getRGB(p);
            return Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
        }
        int size = this.calculateSize();
        p.translate(-(this.getWidth() / 2 - size / 2), -(this.getHeight() / 2 - size / 2));
        if (ColorPickerMode.BRIGHTNESS == this.mode || ColorPickerMode.SATURATION == this.mode) {
            double radius = (double)size / 2.0;
            double x = p.getX() - (double)size / 2.0;
            double y = p.getY() - (double)size / 2.0;
            double r = StrictMath.sqrt(StrictMath.pow(x, 2.0) + StrictMath.pow(y, 2.0)) / radius;
            if (1.0 < r) {
                r = 1.0;
            }
            double theta = StrictMath.atan2(y, x) / (Math.PI * 2);
            if (ColorPickerMode.BRIGHTNESS == this.mode) {
                return new float[]{(float)(theta + 0.25), (float)r, this.bri};
            }
            return new float[]{(float)(theta + 0.25), this.sat, (float)r};
        }
        float s = (float)p.x / (float)size;
        float b = (float)p.y / (float)size;
        if (0.0f > s) {
            s = 0.0f;
        }
        if (1.0f < s) {
            s = 1.0f;
        }
        if (0.0f > b) {
            b = 0.0f;
        }
        if (1.0f < b) {
            b = 1.0f;
        }
        return new float[]{this.hue, s, b};
    }

    private int calculateSize() {
        return Math.min(325, Math.min(this.getWidth() - this.imagePadding.left - this.imagePadding.right, this.getHeight() - this.imagePadding.top - this.imagePadding.bottom));
    }

    private int[] getRGB(Point p) {
        if (ColorPickerMode.BRIGHTNESS == this.mode || ColorPickerMode.SATURATION == this.mode || ColorPickerMode.HUE == this.mode) {
            float[] hsb = this.getHSB(p);
            int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            return new int[]{r, g, b};
        }
        int size = this.calculateSize();
        p.translate(-(this.getWidth() / 2 - size / 2), -(this.getHeight() / 2 - size / 2));
        int x2 = p.x * 255 / size;
        int y2 = p.y * 255 / size;
        if (0 > x2) {
            x2 = 0;
        }
        if (255 < x2) {
            x2 = 255;
        }
        if (0 > y2) {
            y2 = 0;
        }
        if (255 < y2) {
            y2 = 255;
        }
        if (ColorPickerMode.RED == this.mode) {
            return new int[]{this.red, x2, y2};
        }
        if (ColorPickerMode.GREEN == this.mode) {
            return new int[]{x2, this.green, y2};
        }
        return new int[]{x2, y2, this.blue};
    }

    public void setHSB(float h, float s, float b) {
        h = (float)((double)h - Math.floor(h));
        if (0.0f > s || 1.0f < s) {
            throw new IllegalArgumentException("The saturation value (" + s + ") must be between [0,1]");
        }
        if (0.0f > b || 1.0f < b) {
            throw new IllegalArgumentException("The brightness value (" + b + ") must be between [0,1]");
        }
        if (this.hue != h || this.sat != s || this.bri != b) {
            if (ColorPickerMode.HUE == this.mode || ColorPickerMode.BRIGHTNESS == this.mode || ColorPickerMode.SATURATION == this.mode) {
                float lastHue = this.hue;
                float lastBri = this.bri;
                float lastSat = this.sat;
                this.hue = h;
                this.sat = s;
                this.bri = b;
                if (ColorPickerMode.HUE == this.mode) {
                    if (lastHue != this.hue) {
                        this.regenerateImage();
                    }
                } else if (ColorPickerMode.SATURATION == this.mode) {
                    if (lastSat != this.sat) {
                        this.regenerateImage();
                    }
                } else if (ColorPickerMode.BRIGHTNESS == this.mode && lastBri != this.bri) {
                    this.regenerateImage();
                }
            } else {
                Color c = new Color(Color.HSBtoRGB(h, s, b));
                this.setRGB(c.getRed(), c.getGreen(), c.getBlue());
                return;
            }
            Color c = new Color(Color.HSBtoRGB(this.hue, this.sat, this.bri));
            this.red = c.getRed();
            this.green = c.getGreen();
            this.blue = c.getBlue();
            this.regeneratePoint();
            this.repaint();
            this.fireChangeListeners();
        }
    }

    private void regeneratePoint() {
        int size = this.calculateSize();
        if (ColorPickerMode.HUE == this.mode || ColorPickerMode.SATURATION == this.mode || ColorPickerMode.BRIGHTNESS == this.mode) {
            if (ColorPickerMode.HUE == this.mode) {
                this.point = new Point((int)((double)(this.sat * (float)size) + 0.5), (int)((double)(this.bri * (float)size) + 0.5));
            } else if (ColorPickerMode.SATURATION == this.mode) {
                double theta = (double)(this.hue * 2.0f) * Math.PI - 1.5707963267948966;
                if (0.0 > theta) {
                    theta += Math.PI * 2;
                }
                double r = this.bri * (float)size / 2.0f;
                this.point = new Point((int)(r * StrictMath.cos(theta) + 0.5 + (double)size / 2.0), (int)(r * StrictMath.sin(theta) + 0.5 + (double)size / 2.0));
            } else if (ColorPickerMode.BRIGHTNESS == this.mode) {
                double theta = (double)(this.hue * 2.0f) * Math.PI - 1.5707963267948966;
                if (0.0 > theta) {
                    theta += Math.PI * 2;
                }
                double r = this.sat * (float)size / 2.0f;
                this.point = new Point((int)(r * StrictMath.cos(theta) + 0.5 + (double)size / 2.0), (int)(r * StrictMath.sin(theta) + 0.5 + (double)size / 2.0));
            }
        } else if (ColorPickerMode.RED == this.mode) {
            this.point = new Point((int)((float)(this.green * size) / 255.0f + 0.49f), (int)((float)(this.blue * size) / 255.0f + 0.49f));
        } else if (ColorPickerMode.GREEN == this.mode) {
            this.point = new Point((int)((float)(this.red * size) / 255.0f + 0.49f), (int)((float)(this.blue * size) / 255.0f + 0.49f));
        } else if (ColorPickerMode.BLUE == this.mode) {
            this.point = new Point((int)((float)(this.red * size) / 255.0f + 0.49f), (int)((float)(this.green * size) / 255.0f + 0.49f));
        }
    }

    private synchronized void regenerateImage() {
        int size = this.calculateSize();
        if (ColorPickerMode.BRIGHTNESS == this.mode || ColorPickerMode.SATURATION == this.mode) {
            float bri2 = this.bri;
            float sat2 = this.sat;
            float radius = (float)size / 2.0f;
            float k = 1.2f;
            for (int y = 0; y < size; ++y) {
                float y2 = (float)y - (float)size / 2.0f;
                for (int x = 0; x < size; ++x) {
                    double r;
                    float x2 = (float)x - (float)size / 2.0f;
                    double theta = StrictMath.atan2(y2, x2) - 4.71238898038469;
                    if (0.0 > theta) {
                        theta += Math.PI * 2;
                    }
                    if ((r = Math.sqrt(x2 * x2 + y2 * y2)) <= (double)radius) {
                        float hue2;
                        if (ColorPickerMode.BRIGHTNESS == this.mode) {
                            hue2 = (float)(theta / (Math.PI * 2));
                            sat2 = (float)(r / (double)radius);
                        } else {
                            hue2 = (float)(theta / (Math.PI * 2));
                            bri2 = (float)(r / (double)radius);
                        }
                        this.row[x] = Color.HSBtoRGB(hue2, sat2, bri2);
                        if (!(r > (double)(radius - k))) continue;
                        int alpha = (int)(255.0 - 255.0 * (r - (double)radius + (double)k) / (double)k);
                        if (0 > alpha) {
                            alpha = 0;
                        }
                        if (255 < alpha) {
                            alpha = 255;
                        }
                        int n = x;
                        this.row[n] = this.row[n] & 0xFFFFFF + (alpha << 24);
                        continue;
                    }
                    this.row[x] = 0;
                }
                this.image.getRaster().setDataElements(0, y, size, 1, this.row);
            }
        } else if (ColorPickerMode.HUE == this.mode) {
            float hue2 = this.hue;
            for (int y = 0; y < size; ++y) {
                float y2 = (float)y / (float)size;
                for (int x = 0; x < size; ++x) {
                    float x2 = (float)x / (float)size;
                    this.row[x] = Color.HSBtoRGB(hue2, x2, y2);
                }
                this.image.getRaster().setDataElements(0, y, this.image.getWidth(), 1, this.row);
            }
        } else {
            int red2 = this.red;
            int green2 = this.green;
            int blue2 = this.blue;
            for (int y = 0; y < size; ++y) {
                float y2 = (float)y / (float)size;
                for (int x = 0; x < size; ++x) {
                    float x2 = (float)x / (float)size;
                    if (ColorPickerMode.RED == this.mode) {
                        green2 = (int)((double)(x2 * 255.0f) + 0.49);
                        blue2 = (int)((double)(y2 * 255.0f) + 0.49);
                    } else if (ColorPickerMode.GREEN == this.mode) {
                        red2 = (int)((double)(x2 * 255.0f) + 0.49);
                        blue2 = (int)((double)(y2 * 255.0f) + 0.49);
                    } else {
                        red2 = (int)((double)(x2 * 255.0f) + 0.49);
                        green2 = (int)((double)(y2 * 255.0f) + 0.49);
                    }
                    this.row[x] = -16777216 + (red2 << 16) + (green2 << 8) + blue2;
                }
                this.image.getRaster().setDataElements(0, y, size, 1, this.row);
            }
        }
        this.repaint();
    }

    @Override
    public void modeChanged(ModeModel modeModel) {
        this.setMode(modeModel.getMode());
    }

    @Override
    public void colorChanged(ColorModel colorModel) {
        this.colorListenerWrapper.colorChanged(colorModel);
    }

    public void aboutToChangeColor() {
        this.colorListenerWrapper.aboutToChangeValue();
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ColorPickerPanel.this.regeneratePoint();
            ColorPickerPanel.this.regenerateImage();
        }
    }

    private class ColorPickerMouseInputListener
    extends MouseInputAdapter {
        private ColorPickerMouseInputListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ColorPickerPanel.this.calculateSize() > 0) {
                ColorPickerPanel.this.requestFocus();
                Point p = e.getPoint();
                if (ColorPickerMode.BRIGHTNESS == ColorPickerPanel.this.mode || ColorPickerMode.SATURATION == ColorPickerPanel.this.mode || ColorPickerMode.HUE == ColorPickerPanel.this.mode) {
                    float[] hsb = ColorPickerPanel.this.getHSB(p);
                    ColorPickerPanel.this.setHSB(hsb[0], hsb[1], hsb[2]);
                } else {
                    int[] rgb = ColorPickerPanel.this.getRGB(p);
                    ColorPickerPanel.this.setRGB(rgb[0], rgb[1], rgb[2]);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mousePressed(e);
        }
    }

    private class ColorPickerKeyListener
    extends KeyAdapter {
        private ColorPickerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int dx = 0;
            int dy = 0;
            if (37 == e.getKeyCode()) {
                dx = -1;
            } else if (39 == e.getKeyCode()) {
                dx = 1;
            } else if (38 == e.getKeyCode()) {
                dy = -1;
            } else if (40 == e.getKeyCode()) {
                dy = 1;
            }
            int multiplier = 1;
            if (e.isShiftDown() && e.isAltDown()) {
                multiplier = 10;
            } else if (e.isShiftDown() || e.isAltDown()) {
                multiplier = 5;
            }
            if (0 != dx || 0 != dy) {
                int size = ColorPickerPanel.this.calculateSize();
                int offsetX = ColorPickerPanel.this.getWidth() / 2 - size / 2;
                int offsetY = ColorPickerPanel.this.getHeight() / 2 - size / 2;
                ColorPickerPanel.this.mouseListener.mousePressed(new MouseEvent(ColorPickerPanel.this, 501, System.currentTimeMillis(), 0, ((ColorPickerPanel)ColorPickerPanel.this).point.x + multiplier * dx + offsetX, ((ColorPickerPanel)ColorPickerPanel.this).point.y + multiplier * dy + offsetY, 1, false));
            }
        }
    }
}

