/*
 * Decompiled with CFR 0.152.
 */
package com.bric.colorpicker;

import com.bric.colorpicker.ColorPickerMode;
import com.bric.colorpicker.ColorPickerPanel;
import com.bric.colorpicker.colorslider.ColorSlider;
import com.bric.colorpicker.colorslider.ColorSliderUI;
import com.bric.colorpicker.listeners.ColorListener;
import com.bric.colorpicker.listeners.HexFieldListener;
import com.bric.colorpicker.listeners.SelectAllListener;
import com.bric.colorpicker.models.ColorModel;
import com.bric.colorpicker.models.ModeModel;
import com.bric.colorpicker.options.AlphaOption;
import com.bric.colorpicker.options.BlueOption;
import com.bric.colorpicker.options.BrightnessOption;
import com.bric.colorpicker.options.GreenOption;
import com.bric.colorpicker.options.HueOption;
import com.bric.colorpicker.options.Option;
import com.bric.colorpicker.options.RedOption;
import com.bric.colorpicker.options.SaturationOption;
import com.bric.colorpicker.parts.ColorSwatch;
import com.bric.colorpicker.parts.HexField;
import com.bric.colorpicker.parts.OpacitySlider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public class ColorPicker
extends JPanel {
    public static final String MODE_PROPERTY = "mode";
    private static final String SELECTED_COLOR_PROPERTY = "selected color";
    private static final String MODE_CONTROLS_VISIBLE_PROPERTY = "mode controls visible";
    private static final String LOCALIZATION_BUNDLE_PATH = "com.bric.colorpicker.resources.ColorPicker";
    private final ResourceBundle strings;
    private final ColorModel colorModel = new ColorModel();
    private final ModeModel modeModel = new ModeModel();
    private final ColorSlider slider = new ColorSlider();
    private final Option alphaOption;
    private final Option hueOption;
    private final Option saturationOption;
    private final Option brightnessOption;
    private final Option redOption;
    private final Option greenOption;
    private final Option blueOption;
    private final HexField hexField = new HexField();
    private final JPanel expertControls = new JPanel(new GridBagLayout());
    private final ColorPickerPanel colorPanel = new ColorPickerPanel();
    private final OpacitySlider opacitySlider = new OpacitySlider();
    private final ColorSwatch preview;
    private final JLabel hexLabel;
    private final JLabel opacityLabel;

    public ColorPicker() {
        this(true, false);
    }

    public ColorPicker(Locale local) {
        this(true, false, local);
    }

    public ColorPicker(boolean showExpertControls, boolean includeOpacity) {
        this(showExpertControls, includeOpacity, null);
    }

    public ColorPicker(boolean showExpertControls, boolean includeOpacity, Locale locale) {
        super(new GridBagLayout());
        this.strings = locale == null ? ResourceBundle.getBundle(LOCALIZATION_BUNDLE_PATH) : ResourceBundle.getBundle(LOCALIZATION_BUNDLE_PATH, locale);
        GridBagConstraints constraints = new GridBagConstraints();
        Insets normalInsets = new Insets(3, 3, 3, 3);
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = normalInsets;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.hueOption = new HueOption(locale);
        this.saturationOption = new SaturationOption(locale);
        this.brightnessOption = new BrightnessOption(locale);
        this.redOption = new RedOption(locale);
        this.greenOption = new GreenOption(locale);
        this.blueOption = new BlueOption(locale);
        Option[] options = new Option[]{this.hueOption, this.saturationOption, this.brightnessOption, this.redOption, this.greenOption, this.blueOption};
        for (int optionIndex = 0; optionIndex < options.length; ++optionIndex) {
            constraints.insets = optionIndex == 3 || optionIndex == 6 ? new Insets(normalInsets.top + 10, normalInsets.left, normalInsets.bottom, normalInsets.right) : normalInsets;
            options[optionIndex].addTo(optionsPanel, constraints, buttonGroup);
        }
        constraints.insets = new Insets(normalInsets.top + 10, normalInsets.left, normalInsets.bottom, normalInsets.right);
        constraints.anchor = 22;
        constraints.fill = 0;
        this.hexLabel = new JLabel(this.strings.getObject("hexLabel").toString());
        optionsPanel.add((Component)this.hexLabel, constraints);
        ++constraints.gridx;
        constraints.anchor = 21;
        constraints.fill = 2;
        optionsPanel.add((Component)this.hexField, constraints);
        this.alphaOption = new AlphaOption(locale);
        this.alphaOption.addTo(optionsPanel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = normalInsets;
        constraints.gridwidth = 2;
        this.add((Component)this.colorPanel, constraints);
        constraints.gridwidth = 1;
        constraints.insets = normalInsets;
        constraints.gridx += 2;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        constraints.weightx = 0.0;
        this.add((Component)this.slider, constraints);
        ++constraints.gridx;
        constraints.fill = 3;
        constraints.gridheight = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.expertControls, constraints);
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = normalInsets;
        constraints.anchor = 10;
        this.opacityLabel = new JLabel(this.strings.getObject("opacityLabel").toString());
        this.add((Component)this.opacityLabel, constraints);
        ++constraints.gridx;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.add((Component)this.opacitySlider, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.fill = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.anchor = 19;
        constraints.insets = new Insets(normalInsets.top, normalInsets.left + 8, normalInsets.bottom + 10, normalInsets.right + 8);
        this.preview = new ColorSwatch(50, locale);
        this.expertControls.add((Component)this.preview, constraints);
        ++constraints.gridy;
        constraints.weighty = 0.0;
        constraints.anchor = 10;
        constraints.insets = new Insets(normalInsets.top, normalInsets.left, 0, normalInsets.right);
        this.expertControls.add((Component)optionsPanel, constraints);
        this.initNames();
        this.initializeColorPanel();
        this.initializeSlider();
        this.initializePreview();
        this.initializeHexField();
        this.initialize(this.hueOption);
        this.initialize(this.saturationOption);
        this.initialize(this.brightnessOption);
        this.initialize(this.redOption);
        this.initialize(this.greenOption);
        this.initialize(this.blueOption);
        this.initializeOpacitySlider();
        this.initialize(this.alphaOption);
        this.setExpertControlsVisible(showExpertControls);
        this.setOpacityVisible(includeOpacity);
        ColorPicker.setOpaque(this, false);
        this.setColor(Color.BLACK);
        this.setMode(ColorPickerMode.BRIGHTNESS);
    }

    private static void setOpaque(JComponent jc, boolean opaque) {
        if (jc instanceof JTextField) {
            return;
        }
        jc.setOpaque(false);
        if (jc instanceof JSpinner) {
            return;
        }
        for (int a = 0; a < jc.getComponentCount(); ++a) {
            JComponent child = (JComponent)jc.getComponent(a);
            ColorPicker.setOpaque(child, opaque);
        }
    }

    private static void requireValidFloat(float f, String paramName) {
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            throw new IllegalArgumentException("The " + paramName + " value '" + f + "' is not a valid number.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The " + paramName + " value '" + f + "' must be between [0,1]");
        }
    }

    private void initialize(Option option) {
        this.colorModel.addColorListener(option);
        option.addSpinnerChangeListener(e -> {
            if (this.colorModel.isChanging()) {
                return;
            }
            option.aboutToChangeColor();
            option.update(this.colorModel);
        });
        this.modeModel.addListener(option);
        option.addRadioActionListener(e -> {
            if (this.colorModel.isChanging()) {
                return;
            }
            option.aboutToChangeMode();
            option.update(this.modeModel);
        });
        option.addFocusListener(new SelectAllListener());
    }

    private void initializeOpacitySlider() {
        this.colorModel.addColorListener(this.opacitySlider);
        this.opacitySlider.addChangeListener(e -> {
            if (!this.opacitySlider.getValueIsAdjusting()) {
                if (this.colorModel.isChanging()) {
                    return;
                }
                this.opacitySlider.aboutToChangeColor();
                this.colorModel.setAlpha(this.opacitySlider.getValue());
            }
        });
    }

    private void initializeHexField() {
        this.colorModel.addColorListener(this.hexField);
        HexFieldListener hexFieldListener = new HexFieldListener();
        hexFieldListener.setColorModel(this.colorModel);
        hexFieldListener.setHexField(this.hexField);
        this.hexField.getDocument().addDocumentListener(hexFieldListener);
        this.hexField.addFocusListener(new SelectAllListener());
    }

    private void initializePreview() {
        this.preview.setOpaque(true);
        this.colorModel.addColorListener(this.preview);
    }

    private void initializeColorPanel() {
        int height = this.expertControls.getPreferredSize().height;
        this.colorPanel.setPreferredSize(new Dimension(height, height));
        this.colorModel.addColorListener(this.colorPanel);
        this.modeModel.addListener(this.colorPanel);
        this.colorPanel.addChangeListener(e -> {
            if (this.colorModel.isChanging()) {
                return;
            }
            int[] rgb = this.colorPanel.getRGB();
            this.colorPanel.aboutToChangeColor();
            this.colorModel.setColor(new Color(rgb[0], rgb[1], rgb[2]));
        });
    }

    private void initializeSlider() {
        this.colorModel.addColorListener(this.slider);
        this.modeModel.addListener(this.slider);
        this.slider.addChangeListener(e -> {
            if (!this.slider.getValueIsAdjusting()) {
                if (this.colorModel.isChanging()) {
                    return;
                }
                this.slider.aboutToChangeColor();
                ColorPickerMode mode = this.modeModel.getMode();
                switch (mode) {
                    case HUE: {
                        this.colorModel.setHue((float)this.slider.getValue() / (float)mode.getMax());
                        break;
                    }
                    case BRIGHTNESS: {
                        this.colorModel.setBrightness((float)this.slider.getValue() / (float)mode.getMax());
                        break;
                    }
                    case SATURATION: {
                        this.colorModel.setSaturation((float)this.slider.getValue() / (float)mode.getMax());
                        break;
                    }
                    case RED: {
                        this.colorModel.setRed(this.slider.getValue());
                        break;
                    }
                    case GREEN: {
                        this.colorModel.setGreen(this.slider.getValue());
                        break;
                    }
                    case BLUE: {
                        this.colorModel.setBlue(this.slider.getValue());
                    }
                }
            }
        });
        this.slider.setUI(new ColorSliderUI(this.slider, this));
    }

    public Option getSelectedOption() {
        ColorPickerMode mode = this.getMode();
        switch (mode) {
            case HUE: {
                return this.hueOption;
            }
            case SATURATION: {
                return this.saturationOption;
            }
            case BRIGHTNESS: {
                return this.brightnessOption;
            }
            case RED: {
                return this.redOption;
            }
            case GREEN: {
                return this.greenOption;
            }
            case BLUE: {
                return this.blueOption;
            }
        }
        return null;
    }

    private void initNames() {
        this.hexField.setName("Hex");
        this.hueOption.setName("Hue");
        this.saturationOption.setName("Saturation");
        this.brightnessOption.setName("Brightness");
        this.redOption.setName("Red");
        this.greenOption.setName("Green");
        this.blueOption.setName("Blue");
    }

    public void setHexControlsVisible(boolean hexControlsVisible) {
        this.hexLabel.setVisible(hexControlsVisible);
        this.hexField.setVisible(hexControlsVisible);
    }

    public void setPreviewSwatchVisible(boolean previewSwatchVisible) {
        this.preview.setVisible(previewSwatchVisible);
    }

    public void setExpertControlsVisible(boolean b) {
        this.expertControls.setVisible(b);
    }

    public void setModeControlsVisible(boolean visible) {
        this.hueOption.setRadioButtonVisible(visible && this.hueOption.isVisible());
        this.saturationOption.setRadioButtonVisible(visible && this.saturationOption.isVisible());
        this.brightnessOption.setRadioButtonVisible(visible && this.brightnessOption.isVisible());
        this.redOption.setRadioButtonVisible(visible && this.redOption.isVisible());
        this.greenOption.setRadioButtonVisible(visible && this.greenOption.isVisible());
        this.blueOption.setRadioButtonVisible(visible && this.blueOption.isVisible());
        this.putClientProperty(MODE_CONTROLS_VISIBLE_PROPERTY, visible);
    }

    public ColorPickerMode getMode() {
        return this.modeModel.getMode();
    }

    public void setMode(ColorPickerMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        this.modeModel.setMode(mode);
    }

    public void setRGB(int r, int g, int b) {
        this.setColor(new Color(r, g, b));
    }

    public Color getColor() {
        return this.colorModel.getColor();
    }

    public void setColor(Color newColor) {
        Color lastColor = this.colorModel.getColor();
        this.colorModel.setColor(newColor);
        this.firePropertyChange(SELECTED_COLOR_PROPERTY, lastColor, newColor);
    }

    public JPanel getExpertControls() {
        return this.expertControls;
    }

    public void setRGBControlsVisible(boolean b) {
        boolean radioButtonsAllowed = this.areRadioButtonsAllowed();
        this.redOption.setVisible(b, radioButtonsAllowed);
        this.greenOption.setVisible(b, radioButtonsAllowed);
        this.blueOption.setVisible(b, radioButtonsAllowed);
    }

    private boolean areRadioButtonsAllowed() {
        Boolean z = (Boolean)this.getClientProperty(MODE_CONTROLS_VISIBLE_PROPERTY);
        if (z != null) {
            return z;
        }
        return true;
    }

    public void setHSBControlsVisible(boolean b) {
        boolean radioButtonsAllowed = this.areRadioButtonsAllowed();
        this.hueOption.setVisible(b, radioButtonsAllowed);
        this.saturationOption.setVisible(b, radioButtonsAllowed);
        this.brightnessOption.setVisible(b, radioButtonsAllowed);
    }

    public final void setOpacityVisible(boolean visible) {
        this.opacityLabel.setVisible(visible);
        this.opacitySlider.setVisible(visible);
        this.alphaOption.setLabelVisible(visible);
        this.alphaOption.setSpinnerVisible(visible);
    }

    public ColorPickerPanel getColorPanel() {
        return this.colorPanel;
    }

    public void setHSB(float h, float s, float b) {
        ColorPicker.requireValidFloat(h, "hue");
        ColorPicker.requireValidFloat(s, "saturation");
        ColorPicker.requireValidFloat(b, "brightness");
        this.setColor(Color.getHSBColor(h, s, b));
    }

    public float[] getHSB() {
        return this.colorModel.getHSB();
    }

    public int[] getRGB() {
        return this.colorModel.getRGB();
    }

    public void setOpacity(int opacity) {
        this.setColor(new Color(this.colorModel.getRed(), this.colorModel.getGreen(), this.colorModel.getBlue(), opacity));
    }

    public void addColorListener(ColorListener listener) {
        this.colorModel.addColorListener(listener);
    }

    public void removeColorListener(ColorListener listener) {
        this.colorModel.removeColorListener(listener);
    }
}

