/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import java.util.ArrayList;
import java.util.Arrays;

public class Ttl74381
extends AbstractTtlGate {
    public static final String _ID = "74381";
    public static final int DELAY = 1;
    public static final byte A0 = 3;
    public static final byte A1 = 1;
    public static final byte A2 = 19;
    public static final byte A3 = 17;
    public static final byte B0 = 4;
    public static final byte B1 = 2;
    public static final byte B2 = 18;
    public static final byte B3 = 16;
    public static final byte F0 = 8;
    public static final byte F1 = 9;
    public static final byte F2 = 11;
    public static final byte F3 = 12;
    public static final byte S0 = 5;
    public static final byte S1 = 6;
    public static final byte S2 = 7;
    public static final byte Ci = 15;
    public static final byte P = 14;
    public static final byte G = 13;
    public static final byte GND = 10;
    public static final byte VCC = 20;
    private InstanceState state;

    public Ttl74381() {
        super(_ID, (byte)20, new byte[]{8, 9, 11, 12, 14, 13}, new String[]{"A1", "B1", "A0", "B0", "S0", "S1", "S2", "F0", "F1", "F2", "F3", "Gn", "Pn", "Ci", "B3", "A3", "B2", "A2"}, null);
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        int labelLenMax = 4;
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.portNames) {
            String[] tmp = name.split("\\s+");
            names.add(tmp[0].length() <= 4 ? tmp[0] : tmp[0].substring(0, 4));
        }
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, names.toArray(new String[0]));
    }

    protected byte pinNrToPortNr(byte dsPinNr) {
        return (byte)(dsPinNr <= 10 ? dsPinNr - 1 : dsPinNr - 2);
    }

    private boolean getPort(byte dsPinNr) {
        return this.state.getPortValue(this.pinNrToPortNr(dsPinNr)) == Value.TRUE;
    }

    private void setPort(byte dsPinNr, boolean b) {
        this.state.setPort(this.pinNrToPortNr(dsPinNr), b ? Value.TRUE : Value.FALSE, 1);
    }

    private boolean pal32L1(ArrayList<Boolean> in, int[] products) {
        boolean or = false;
        for (int i = 0; i < products.length && !or; ++i) {
            int product = products[i];
            boolean and = true;
            for (int j = 0; j < 32 && and; ++j) {
                if ((product & 1 << j) == 0) continue;
                and = in.get(j);
            }
            or = and;
        }
        return !or;
    }

    @Override
    public void propagateTtl(InstanceState state) {
        this.state = state;
        final ArrayList<Boolean> a = new ArrayList<Boolean>(Arrays.asList(this.getPort((byte)3), this.getPort((byte)1), this.getPort((byte)19), this.getPort((byte)17)));
        final ArrayList<Boolean> an = new ArrayList<Boolean>(a.stream().map(x -> x == false).toList());
        final ArrayList<Boolean> b = new ArrayList<Boolean>(Arrays.asList(this.getPort((byte)4), this.getPort((byte)2), this.getPort((byte)18), this.getPort((byte)16)));
        final ArrayList<Boolean> bn = new ArrayList<Boolean>(b.stream().map(x -> x == false).toList());
        ArrayList<Boolean> s = new ArrayList<Boolean>(Arrays.asList(this.getPort((byte)5), this.getPort((byte)6), this.getPort((byte)7)));
        final boolean ci = this.getPort((byte)15);
        final boolean u = s.get(0) != false || s.get(1) != false;
        final boolean v = s.get(1) != false || s.get(2) != false;
        final boolean w = s.get(0) != false || s.get(1) == false;
        final boolean x2 = s.get(0) == false || s.get(1) == false || s.get(2) != false;
        final boolean y = s.get(0) != false && s.get(1) != false || s.get(2) == false;
        final boolean z = s.get(2) == false && u;
        ArrayList<Boolean> level1 = new ArrayList<Boolean>(this){
            final /* synthetic */ Ttl74381 this$0;
            {
                this.this$0 = this$0;
                this.addAll(a);
                this.addAll(an);
                this.addAll(b);
                this.addAll(bn);
                this.add(y);
                this.add(x2);
                this.add(w);
                this.add(v);
                this.add(u);
            }
        };
        final ArrayList<Boolean> j = new ArrayList<Boolean>(Arrays.asList(this.pal32L1(level1, new int[]{790544, 0x161001, 655632}), this.pal32L1(level1, new int[]{794656, 1449986, 655904}), this.pal32L1(level1, new int[]{802880, 1458180, 656448}), this.pal32L1(level1, new int[]{819328, 1474568, 657536})));
        final ArrayList<Boolean> k = new ArrayList<Boolean>(Arrays.asList(this.pal32L1(level1, new int[]{0x131010, 790529, 786704, 0x120101}), this.pal32L1(level1, new int[]{1253408, 794626, 786976, 0x120202}), this.pal32L1(level1, new int[]{1261632, 802820, 787520, 1180676}), this.pal32L1(level1, new int[]{1278080, 819208, 788608, 1181704})));
        ArrayList<Boolean> level2 = new ArrayList<Boolean>(this){
            final /* synthetic */ Ttl74381 this$0;
            {
                this.this$0 = this$0;
                this.addAll(j);
                this.addAll(k);
                this.add(z);
                this.add(ci);
            }
        };
        ArrayList<Boolean> l = new ArrayList<Boolean>(Arrays.asList(this.pal32L1(level2, new int[]{768}), this.pal32L1(level2, new int[]{769, 273}), this.pal32L1(level2, new int[]{771, 275, 290}), this.pal32L1(level2, new int[]{775, 279, 294, 324})));
        boolean p = this.pal32L1(level2, new int[]{15});
        boolean g = this.pal32L1(level2, new int[]{136, 76, 46, 31});
        boolean f0 = l.get(0) ^ k.get(0);
        boolean f1 = l.get(1) ^ k.get(1);
        boolean f2 = l.get(2) ^ k.get(2);
        boolean f3 = l.get(3) ^ k.get(3);
        this.setPort((byte)14, p);
        this.setPort((byte)13, g);
        this.setPort((byte)12, f3);
        this.setPort((byte)11, f2);
        this.setPort((byte)9, f1);
        this.setPort((byte)8, f0);
    }
}

