/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.memory.MemState;
import com.cburch.logisim.std.memory.RomAttributes;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class MemPoker
extends InstancePoker {
    private MemPoker sub;

    @Override
    public Bounds getBounds(InstancePainter state) {
        return this.sub.getBounds(state);
    }

    @Override
    public boolean init(InstanceState state, MouseEvent event) {
        Bounds bds = state.getInstance().getBounds();
        MemState data = (MemState)state.getData();
        long addr = data.getAddressAt(event.getX() - bds.getX(), event.getY() - bds.getY());
        this.sub = addr < 0L ? new AddrPoker() : new DataPoker(state, data, addr);
        return true;
    }

    @Override
    public void keyPressed(InstanceState state, KeyEvent e) {
        this.sub.keyPressed(state, e);
    }

    @Override
    public void keyTyped(InstanceState state, KeyEvent e) {
        this.sub.keyTyped(state, e);
    }

    @Override
    public void paint(InstancePainter painter) {
        this.sub.paint(painter);
    }

    private static class AddrPoker
    extends MemPoker {
        private AddrPoker() {
        }

        @Override
        public Bounds getBounds(InstancePainter painter) {
            MemState data = (MemState)painter.getData();
            return data.getBounds(-1L, painter.getBounds());
        }

        @Override
        public void keyTyped(InstanceState state, KeyEvent e) {
            int val = Character.digit(e.getKeyChar(), 16);
            MemState data = (MemState)state.getData();
            if (val >= 0) {
                long newScroll = data.getScroll() * 16L + (long)val & data.getLastAddress();
                data.setScroll(newScroll);
            } else {
                switch (e.getKeyChar()) {
                    case ' ': {
                        if (e.isControlDown()) {
                            data.setScroll(data.getScroll() + (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                            break;
                        }
                        data.setScroll(data.getScroll() + (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (e.isControlDown()) {
                            data.setScroll(data.getScroll() - (long)data.getNrOfLineItems());
                            break;
                        }
                        data.setScroll(data.getScroll() + (long)data.getNrOfLineItems());
                        break;
                    }
                    case '\b': {
                        data.setScroll(data.getScroll() - (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                        break;
                    }
                    case '\u007f': {
                        if (!e.isControlDown()) break;
                        data.setScroll(data.getScroll() - (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        data.getContents().clear();
                        break;
                    }
                }
            }
        }

        @Override
        public void keyPressed(InstanceState state, KeyEvent e) {
            MemState data = (MemState)state.getData();
            switch (e.getKeyCode()) {
                case 38: {
                    data.setScroll(data.getScroll() - (long)data.getNrOfLineItems());
                    break;
                }
                case 40: {
                    data.setScroll(data.getScroll() + (long)data.getNrOfLineItems());
                    break;
                }
                case 37: {
                    data.setScroll(data.getScroll() - (long)data.getNrOfLineItems());
                    break;
                }
                case 39: {
                    data.setScroll(data.getScroll() + (long)data.getNrOfLineItems());
                    break;
                }
                case 33: {
                    data.setScroll(data.getScroll() - (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                    break;
                }
                case 34: {
                    data.setScroll(data.getScroll() + (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                    break;
                }
            }
            e.consume();
        }

        @Override
        public void paint(InstancePainter painter) {
            Bounds bds = this.getBounds(painter);
            Graphics g = painter.getGraphics();
            g.setColor(Color.RED);
            g.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            g.setColor(Color.BLACK);
        }
    }

    private static class DataPoker
    extends MemPoker {
        long initValue;
        long curValue;

        private DataPoker(InstanceState state, MemState data, long addr) {
            Project proj;
            data.setCursor(addr);
            this.curValue = this.initValue = data.getContents().get(data.getCursor());
            AttributeSet attrs = state.getInstance().getAttributeSet();
            if (attrs instanceof RomAttributes && (proj = state.getProject()) != null) {
                ((RomAttributes)attrs).setProject(proj);
            }
        }

        @Override
        public Bounds getBounds(InstancePainter painter) {
            MemState data = (MemState)painter.getData();
            Bounds inBounds = painter.getInstance().getBounds();
            return data.getDataBounds(data.getCursor(), inBounds);
        }

        @Override
        public void keyTyped(InstanceState state, KeyEvent e) {
            int val = Character.digit(e.getKeyChar(), 16);
            MemState data = (MemState)state.getData();
            if (val >= 0) {
                this.curValue = this.curValue * 16L + (long)val;
                data.getContents().set(data.getCursor(), this.curValue);
                state.fireInvalidated();
            } else {
                switch (e.getKeyChar()) {
                    case ' ': {
                        if (e.isControlDown()) {
                            this.moveTo(data, data.getCursor() + (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                            break;
                        }
                        this.moveTo(data, data.getCursor() + 1L);
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (e.isControlDown()) {
                            this.moveTo(data, data.getCursor() - (long)data.getNrOfLineItems());
                            break;
                        }
                        this.moveTo(data, data.getCursor() + (long)data.getNrOfLineItems());
                        break;
                    }
                    case '\b': {
                        this.moveTo(data, data.getCursor() - 1L);
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        data.getContents().clear();
                        break;
                    }
                    case '\u007f': {
                        if (e.isControlDown()) {
                            this.moveTo(data, data.getCursor() - (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                            break;
                        }
                        data.getContents().set(data.getCursor(), 0L);
                        break;
                    }
                }
            }
        }

        @Override
        public void keyPressed(InstanceState state, KeyEvent e) {
            MemState data = (MemState)state.getData();
            switch (e.getKeyCode()) {
                case 38: {
                    this.moveTo(data, data.getCursor() - (long)data.getNrOfLineItems());
                    break;
                }
                case 40: {
                    this.moveTo(data, data.getCursor() + (long)data.getNrOfLineItems());
                    break;
                }
                case 37: {
                    this.moveTo(data, data.getCursor() - 1L);
                    break;
                }
                case 39: {
                    this.moveTo(data, data.getCursor() + 1L);
                    break;
                }
                case 33: {
                    this.moveTo(data, data.getCursor() - (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                    break;
                }
                case 34: {
                    this.moveTo(data, data.getCursor() + (long)((data.getNrOfLines() - 1) * data.getNrOfLineItems()));
                    break;
                }
            }
            e.consume();
        }

        private void moveTo(MemState data, long addr) {
            if (data.isValidAddr(addr)) {
                data.setCursor(addr);
                data.scrollToShow(addr);
                this.curValue = this.initValue = data.getContents().get(addr);
            }
        }

        @Override
        public void paint(InstancePainter painter) {
            Bounds bds = this.getBounds(painter);
            if (bds == null || bds == Bounds.EMPTY_BOUNDS) {
                return;
            }
            Graphics g = painter.getGraphics();
            g.setColor(Color.RED);
            g.drawRect(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
            g.setColor(Color.BLACK);
        }

        @Override
        public void stopEditing(InstanceState state) {
            MemState data = (MemState)state.getData();
            data.setCursor(-1L);
        }
    }
}

