/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.logisim.std.hdl.DenseLogicCircuit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public final class DenseLogicCircuitBuilder {
    public static final boolean DEBUG = false;
    private ArrayList<GateInfo> gates = new ArrayList();
    private ArrayList<CellInfo> cells = new ArrayList();
    private ArrayList<Integer> seqScript = new ArrayList();
    public final HashMap<String, Integer> symbolTable = new HashMap();
    private int seqDataSize = 0;

    public DenseLogicCircuitBuilder() {
        for (int i = 0; i < 4; ++i) {
            CellInfo ci = new CellInfo(this, i, true);
            ci.pull = (byte)i;
            this.cells.add(ci);
        }
    }

    public void attachGate(int gateType, int a, int b, int o) {
        CellInfo outCellInfo = this.cells.get(o);
        GateInfo oldGate = outCellInfo.currentDrivingGate;
        if (oldGate != null) {
            if (oldGate.pinA == oldGate.pinB && oldGate.type == 0) {
                if (a == b && gateType == 0) {
                    oldGate.setPinB(this.cells.get(b));
                } else {
                    CellInfo newGateOut = this.addCellInternal(false);
                    this.addGate(gateType, this.cells.get(a), this.cells.get(b)).setOutput(newGateOut);
                    oldGate.setPinB(newGateOut);
                }
            } else {
                CellInfo oldGateOut = this.addCellInternal(false);
                oldGate.setOutput(oldGateOut);
                if (a == b && gateType == 0) {
                    this.addGate(0, oldGateOut, this.cells.get(a)).setOutput(outCellInfo);
                } else {
                    CellInfo newGateOut = this.addCellInternal(false);
                    this.addGate(gateType, this.cells.get(a), this.cells.get(b)).setOutput(newGateOut);
                    this.addGate(0, oldGateOut, newGateOut).setOutput(outCellInfo);
                }
            }
        } else {
            this.addGate(gateType, this.cells.get(a), this.cells.get(b)).setOutput(outCellInfo);
        }
    }

    public void attachBuffer(int from, int to) {
        this.attachGate(0, from, from, to);
    }

    public DenseLogicCircuit build() {
        HashMap<Integer, String> inverseMap = new HashMap<Integer, String>();
        for (Map.Entry<String, Integer> ent : this.symbolTable.entrySet()) {
            inverseMap.put(ent.getValue(), ent.getKey());
        }
        byte[] cellPull = new byte[this.cells.size()];
        int[][] cellUpdateNotifiesGate = new int[this.cells.size()][];
        for (int i = 0; i < cellPull.length; ++i) {
            CellInfo cell = this.cells.get(i);
            cellPull[i] = cell.pull;
            int[] notifyArray = new int[cell.notifiesTheseGates.size()];
            int idx = 0;
            for (Integer gate : cell.notifiesTheseGates) {
                notifyArray[idx++] = gate;
            }
            cellUpdateNotifiesGate[i] = notifyArray;
        }
        byte[] gateTypes = new byte[this.gates.size()];
        int[] gateCellA = new int[gateTypes.length];
        int[] gateCellB = new int[gateTypes.length];
        int[] gateCellO = new int[gateTypes.length];
        for (int i = 0; i < gateTypes.length; ++i) {
            GateInfo gi = this.gates.get(i);
            gateTypes[i] = (byte)gi.type;
            gateCellA[i] = gi.pinA.index;
            gateCellB[i] = gi.pinB.index;
            gateCellO[i] = gi.pinOutput.index;
        }
        int[] seq = new int[this.seqScript.size()];
        for (int i = 0; i < seq.length; ++i) {
            seq[i] = this.seqScript.get(i);
        }
        return new DenseLogicCircuit(cellPull, cellUpdateNotifiesGate, gateTypes, gateCellA, gateCellB, gateCellO, seq, this.seqDataSize, Collections.unmodifiableMap(new HashMap<String, Integer>(this.symbolTable)));
    }

    private void debugWriteCell(Map<Integer, String> inverseMap, int i) {
        System.out.print("C");
        System.out.print(i);
        String sym = inverseMap.get(i);
        if (sym != null) {
            System.out.print(" (" + sym + ")");
        }
    }

    private CellInfo addCellInternal(boolean ext) {
        int idx = this.cells.size();
        CellInfo ci = new CellInfo(this, idx, ext);
        this.cells.add(ci);
        return ci;
    }

    public int addCell(boolean ext) {
        return this.addCellInternal((boolean)ext).index;
    }

    public void setCellPull(int cell, int pull) {
        this.cells.get((int)cell).pull = (byte)pull;
    }

    private GateInfo addGate(int type, CellInfo a, CellInfo b) {
        int gateIndex = this.gates.size();
        GateInfo gi = new GateInfo(this, gateIndex, type, a, b);
        this.gates.add(gi);
        return gi;
    }

    public int addDff(int c, int d) {
        int q = this.addCellInternal((boolean)true).index;
        int x = this.seqDataSize++;
        this.seqScript.add(0);
        this.seqScript.add(d);
        this.seqScript.add(c);
        this.seqScript.add(q);
        this.seqScript.add(x);
        this.setCellPull(q, 1);
        return q;
    }

    public int addDffsr(int c, int d, int s, int r) {
        int q = this.addCellInternal((boolean)true).index;
        int xc = this.seqDataSize++;
        this.seqScript.add(0);
        this.seqScript.add(d);
        this.seqScript.add(c);
        this.seqScript.add(q);
        this.seqScript.add(xc);
        this.seqScript.add(1);
        this.seqScript.add(2);
        this.seqScript.add(s);
        this.seqScript.add(q);
        this.seqScript.add(1);
        this.seqScript.add(1);
        this.seqScript.add(r);
        this.seqScript.add(q);
        this.setCellPull(q, 1);
        return q;
    }

    public int addLatch(int d, int e) {
        int q = this.addCellInternal((boolean)true).index;
        this.seqScript.add(1);
        this.seqScript.add(d);
        this.seqScript.add(e);
        this.seqScript.add(q);
        this.setCellPull(q, 1);
        return q;
    }

    private class CellInfo {
        final int index;
        GateInfo currentDrivingGate;
        boolean externallyDriven;
        byte pull = 0;
        TreeSet<Integer> notifiesTheseGates = new TreeSet();

        CellInfo(DenseLogicCircuitBuilder denseLogicCircuitBuilder, int index, boolean ext) {
            this.index = index;
            this.externallyDriven = ext;
        }
    }

    private class GateInfo {
        final int type;
        final int index;
        CellInfo pinA;
        CellInfo pinB;
        CellInfo pinOutput;

        GateInfo(DenseLogicCircuitBuilder denseLogicCircuitBuilder, int index, int t, CellInfo a, CellInfo b) {
            this.index = index;
            this.type = t;
            this.pinA = a;
            a.notifiesTheseGates.add(index);
            this.pinB = b;
            b.notifiesTheseGates.add(index);
        }

        void setPinB(CellInfo b) {
            if (this.pinA != this.pinB) {
                this.pinB.notifiesTheseGates.remove(this.index);
            }
            this.pinB = b;
            this.pinB.notifiesTheseGates.add(this.index);
        }

        GateInfo setOutput(CellInfo cell) {
            if (this.pinOutput != null) {
                this.pinOutput.currentDrivingGate = null;
                this.pinOutput = null;
            }
            if (cell != null) {
                if (cell.externallyDriven) {
                    throw new RuntimeException("Cannot set driving gate for an externally driven cell!");
                }
                if (cell.currentDrivingGate != null) {
                    throw new RuntimeException("setOutput does not insert bus gates automatically!");
                }
                cell.currentDrivingGate = this;
            }
            this.pinOutput = cell;
            return this;
        }
    }
}

