/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.rv32im.RV32imState;
import com.cburch.logisim.soc.rv32im.RV32imSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;
import java.util.Arrays;

public class RV32im_Zicsr_ExtensionInstructions
implements AssemblerExecutionInterface {
    private static final int OP = 115;
    private static final int INSTR_CSRRW = 0;
    private static final int INSTR_CSRRS = 1;
    private static final int INSTR_CSRRC = 2;
    private static final int INSTR_CSRRWI = 3;
    private static final int INSTR_CSRRSI = 4;
    private static final int INSTR_CSRRCI = 5;
    private static final String[] AsmOpcodes = new String[]{"CSRRW", "CSRRS", "CSRRC", "CSRRWI", "CSRRSI", "CSRRCI", "CSRW", "CSRS", "CSRC", "CSRWI", "CSRSI", "CSRCI"};
    private int instruction;
    private boolean valid;
    private int operation;
    private int destination;
    private int source;
    private int sprIndex;

    @Override
    public boolean execute(Object processorState, CircuitState circuitState) {
        if (!this.valid) {
            return false;
        }
        RV32imState.ProcessorState cpuState = (RV32imState.ProcessorState)processorState;
        int val = cpuState.getRegisterValue(this.source);
        switch (this.operation) {
            case 0: {
                if (!RV32imState.isSprImplemented(this.sprIndex)) {
                    return false;
                }
                if (this.destination != 0) {
                    cpuState.writeRegister(this.destination, cpuState.getCsrValue(this.sprIndex));
                }
                cpuState.writeCsr(this.sprIndex, val);
                return true;
            }
            case 1: {
                if (!RV32imState.isSprImplemented(this.sprIndex)) {
                    return false;
                }
                if (this.destination != 0) {
                    cpuState.writeRegister(this.destination, cpuState.getCsrValue(this.sprIndex));
                }
                int csrContents = cpuState.getCsrValue(this.sprIndex);
                cpuState.writeCsr(this.sprIndex, val | csrContents);
                return true;
            }
            case 2: {
                if (!RV32imState.isSprImplemented(this.sprIndex)) {
                    return false;
                }
                if (this.destination != 0) {
                    cpuState.writeRegister(this.destination, cpuState.getCsrValue(this.sprIndex));
                }
                int csrContents = cpuState.getCsrValue(this.sprIndex);
                int mask = ~val;
                cpuState.writeCsr(this.sprIndex, mask & csrContents);
                return true;
            }
            case 3: {
                if (!RV32imState.isSprImplemented(this.sprIndex)) {
                    return false;
                }
                if (this.destination != 0) {
                    cpuState.writeRegister(this.destination, cpuState.getCsrValue(this.sprIndex));
                }
                cpuState.writeCsr(this.sprIndex, this.source);
                return true;
            }
            case 4: {
                if (!RV32imState.isSprImplemented(this.sprIndex)) {
                    return false;
                }
                if (this.destination != 0) {
                    cpuState.writeRegister(this.destination, cpuState.getCsrValue(this.sprIndex));
                }
                int csrContents = cpuState.getCsrValue(this.sprIndex);
                cpuState.writeCsr(this.sprIndex, this.source | csrContents);
                return true;
            }
            case 5: {
                if (!RV32imState.isSprImplemented(this.sprIndex)) {
                    return false;
                }
                if (this.destination != 0) {
                    cpuState.writeRegister(this.destination, cpuState.getCsrValue(this.sprIndex));
                }
                int csrContents = cpuState.getCsrValue(this.sprIndex);
                int mask = ~this.source;
                cpuState.writeCsr(this.sprIndex, mask & csrContents);
                return true;
            }
        }
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        int realOp = this.destination == 0 ? this.operation + 6 : this.operation;
        s.append(AsmOpcodes[realOp].toLowerCase());
        while (s.length() < 10) {
            s.append(" ");
        }
        if (this.destination != 0) {
            s.append(RV32imState.registerABINames[this.destination]).append(",");
        }
        s.append(RV32imState.getSprName(this.sprIndex)).append(",").append(this.operation < 3 ? RV32imState.registerABINames[this.source] : String.format("0x%02X", this.source));
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        int operation = -1;
        this.valid = true;
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            if (!AsmOpcodes[i].equals(instr.getOpcode().toUpperCase())) continue;
            operation = i;
        }
        if (operation < 0) {
            this.valid = false;
            return false;
        }
        if (instr.getNrOfParameters() == 2) {
            if (operation < 6) {
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedThreeArguments"));
                this.valid = false;
                return false;
            }
            operation -= 6;
            this.destination = 0;
            AssemblerToken[] param1 = instr.getParameter(0);
            AssemblerToken[] param2 = instr.getParameter(1);
            if (param1.length != 1) {
                instr.setError(param1[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                this.valid = false;
                return false;
            }
            if (param1[0].getType() == 5) {
                int sprIndex = RV32imState.getSprArrayIndex(param1[0].getValue());
                if (sprIndex < 0) {
                    instr.setError(param1[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                    this.valid = false;
                    return false;
                }
                this.instruction = 115;
                this.instruction |= RV32imState.getSprValue(sprIndex) << 20;
            } else if (param1[0].getType() == 7 || param1[0].getType() == 6) {
                this.instruction = 115;
                this.instruction |= param1[0].getNumberValue() << 20;
            } else {
                instr.setError(param1[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                this.valid = false;
                return false;
            }
            if (param2.length != 1) {
                instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                this.valid = false;
                return false;
            }
            if (param2[0].getType() == 5) {
                int regIndex = RV32imState.getRegisterIndex(param2[0].getValue());
                if (regIndex < 0) {
                    instr.setError(param2[0], Strings.S.getter("AssemblerExpectedRegister"));
                    this.valid = false;
                    return false;
                }
                this.instruction |= regIndex << 15;
            } else if (param2[0].getType() == 7 || param2[0].getType() == 6) {
                int value = param2[0].getNumberValue();
                if (value < 0 || value > 31) {
                    instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                    this.valid = false;
                    return false;
                }
                this.instruction |= value << 15;
            } else {
                instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                this.valid = false;
                return false;
            }
            this.instruction |= operation < 3 ? operation + 1 << 12 : operation + 2 << 12;
            instr.setInstructionByteCode(this.instruction, 4);
            return true;
        }
        if (instr.getNrOfParameters() == 3) {
            if (operation > 5) {
                instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
                this.valid = false;
                return false;
            }
            AssemblerToken[] param1 = instr.getParameter(0);
            AssemblerToken[] param2 = instr.getParameter(1);
            AssemblerToken[] param3 = instr.getParameter(2);
            if (param1.length != 1) {
                instr.setError(param1[0], Strings.S.getter("AssemblerExpectedRegister"));
                this.valid = false;
                return false;
            }
            if (param1[0].getType() == 5) {
                int reg = RV32imState.getRegisterIndex(param1[0].getValue());
                if (reg < 0) {
                    instr.setError(param1[0], Strings.S.getter("AssemblerExpectedRegister"));
                    this.valid = false;
                    return false;
                }
                this.instruction = 115;
                this.instruction |= reg << 7;
            } else {
                instr.setError(param1[0], Strings.S.getter("AssemblerExpectedRegister"));
                this.valid = false;
                return false;
            }
            if (param2.length != 1) {
                instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                this.valid = false;
                return false;
            }
            if (param2[0].getType() == 5) {
                int sprIndex = RV32imState.getSprArrayIndex(param2[0].getValue());
                if (sprIndex < 0) {
                    instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                    this.valid = false;
                    return false;
                }
                this.instruction |= RV32imState.getSprValue(sprIndex) << 20;
            } else if (param2[0].getType() == 7 || param2[0].getType() == 6) {
                this.instruction |= param2[0].getNumberValue() << 20;
            } else {
                instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                this.valid = false;
                return false;
            }
            if (param3.length != 1) {
                instr.setError(param3[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                this.valid = false;
                return false;
            }
            if (param3[0].getType() == 5) {
                int regIndex = RV32imState.getRegisterIndex(param3[0].getValue());
                if (regIndex < 0) {
                    instr.setError(param3[0], Strings.S.getter("AssemblerExpectedRegister"));
                    this.valid = false;
                    return false;
                }
                this.instruction |= regIndex << 15;
            } else if (param3[0].getType() == 7 || param3[0].getType() == 6) {
                int value = param3[0].getNumberValue();
                if (value < 0 || value > 31) {
                    instr.setError(param3[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                    this.valid = false;
                    return false;
                }
                this.instruction |= value << 15;
            } else {
                instr.setError(param3[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
                this.valid = false;
                return false;
            }
            this.instruction |= operation < 3 ? operation + 1 << 12 : operation + 2 << 12;
            instr.setInstructionByteCode(this.instruction, 4);
            return true;
        }
        return false;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = this.decodeBin();
        return this.valid;
    }

    private boolean decodeBin() {
        if (RV32imSupport.getOpcode(this.instruction) == 115) {
            switch (RV32imSupport.getFunct3(this.instruction)) {
                case 1: {
                    this.operation = 0;
                    break;
                }
                case 2: {
                    this.operation = 1;
                    break;
                }
                case 3: {
                    this.operation = 2;
                    break;
                }
                case 5: {
                    this.operation = 3;
                    break;
                }
                case 6: {
                    this.operation = 4;
                    break;
                }
                case 7: {
                    this.operation = 5;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.sprIndex = this.instruction >> 20 & 0xFFF;
            this.destination = RV32imSupport.getDestinationRegisterIndex(this.instruction);
            this.source = RV32imSupport.getSourceRegister1Index(this.instruction);
            return true;
        }
        return false;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public ArrayList<String> getInstructions() {
        return new ArrayList<String>(Arrays.asList(AsmOpcodes));
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.getInstructions().contains(instruction.toUpperCase())) {
            return 4;
        }
        return -1;
    }
}

