/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.gui.log.LogFrame;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.PrintHandler;
import com.cburch.logisim.proj.Project;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public abstract class LogPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final LogFrame logFrame;

    public LogPanel(LogFrame frame) {
        this.logFrame = frame;
    }

    public LogPanel(LogFrame frame, LayoutManager manager) {
        super(manager);
        this.logFrame = frame;
    }

    public abstract String getHelpText();

    void updateTab() {
        EditHandler h = this.getEditHandler();
        if (h != null) {
            h.computeEnabled();
        }
    }

    public EditHandler getEditHandler() {
        return null;
    }

    public PrintHandler getPrintHandler() {
        return null;
    }

    public LogFrame getLogFrame() {
        return this.logFrame;
    }

    protected LogisimMenuBar getLogisimMenuBar() {
        return this.logFrame.getLogisimMenuBar();
    }

    protected Model getModel() {
        return this.logFrame.getModel();
    }

    protected Project getProject() {
        return this.logFrame.getProject();
    }

    public abstract String getTitle();

    public void localeChanged() {
    }

    public void modelChanged(Model oldModel, Model newModel) {
    }
}

