/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.fpga.designrulecheck.ConnectionPoint;
import com.cburch.logisim.fpga.designrulecheck.Net;
import java.util.ArrayList;

public class ConnectionEnd {
    private final boolean isOutput;
    private final Byte nrOfBits;
    private final ArrayList<ConnectionPoint> myConnections;

    public ConnectionEnd(boolean isOutputEnd, Byte nrOfBits, Component comp) {
        this.isOutput = isOutputEnd;
        this.nrOfBits = nrOfBits;
        this.myConnections = new ArrayList();
        for (byte i = 0; i < nrOfBits; i = (byte)(i + 1)) {
            this.myConnections.add(new ConnectionPoint(comp));
        }
    }

    public ConnectionPoint get(Byte bitIndex) {
        if (bitIndex < 0 || bitIndex >= this.nrOfBits) {
            return null;
        }
        return this.myConnections.get(bitIndex.byteValue());
    }

    public boolean isOutputEnd() {
        return this.isOutput;
    }

    public int getNrOfBits() {
        return this.nrOfBits.byteValue();
    }

    public boolean setChildPortIndex(Net connectedNet, Byte bitIndex, int portIndex) {
        if (bitIndex < 0 || bitIndex >= this.nrOfBits) {
            return false;
        }
        ConnectionPoint Connection2 = this.myConnections.get(bitIndex.byteValue());
        if (Connection2 == null) {
            return false;
        }
        Connection2.setChildsPortIndex(portIndex);
        return true;
    }

    public boolean setConnection(ConnectionPoint Connection2, Byte BitIndex) {
        if (BitIndex < 0 || BitIndex >= this.nrOfBits) {
            return false;
        }
        this.myConnections.set(BitIndex.byteValue(), Connection2);
        return true;
    }
}

