/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.comp;

import com.cburch.logisim.comp.TextField;
import com.cburch.logisim.comp.TextFieldEvent;
import com.cburch.logisim.comp.TextFieldListener;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.CaretEvent;
import com.cburch.logisim.tools.CaretListener;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;

class TextFieldCaret
implements Caret,
TextFieldListener {
    public static final Color EDIT_BACKGROUND = new Color(255, 255, 153);
    public static final Color EDIT_BORDER = Color.DARK_GRAY;
    public static final Color SELECTION_BACKGROUND = new Color(153, 204, 255);
    private final LinkedList<CaretListener> listeners = new LinkedList();
    private final TextField field;
    private final Graphics g;
    private String oldText;
    private String curText;
    private int pos;
    private int end;

    public TextFieldCaret(TextField field, Graphics g, int pos) {
        this.field = field;
        this.g = g;
        this.oldText = field.getText();
        this.curText = field.getText();
        this.pos = pos;
        this.end = pos;
        field.addTextFieldListener(this);
    }

    public TextFieldCaret(TextField field, Graphics g, int x, int y) {
        this(field, g, 0);
        this.pos = this.end = this.findCaret(x, y);
    }

    @Override
    public void addCaretListener(CaretListener l) {
        this.listeners.add(l);
    }

    @Override
    public void cancelEditing() {
        CaretEvent e = new CaretEvent(this, this.oldText, this.oldText);
        this.curText = this.oldText;
        this.end = this.pos = this.curText.length();
        for (CaretListener l : new ArrayList<CaretListener>(this.listeners)) {
            l.editingCanceled(e);
        }
        this.field.removeTextFieldListener(this);
    }

    @Override
    public void commitText(String text) {
        this.curText = text;
        this.end = this.pos = this.curText.length();
        this.field.setText(text);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle p;
        int x = this.field.getX();
        int y = this.field.getY();
        int halign = this.field.getHAlign();
        int valign = this.field.getVAlign();
        if (this.field.getFont() != null) {
            g.setFont(this.field.getFont());
        }
        Bounds box = this.getBounds(g);
        g.setColor(EDIT_BACKGROUND);
        g.fillRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
        g.setColor(EDIT_BORDER);
        g.drawRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
        if (this.pos != this.end) {
            g.setColor(SELECTION_BACKGROUND);
            p = GraphicsUtil.getTextCursor(g, this.curText, x, y, Math.min(this.pos, this.end), halign, valign);
            Rectangle e = GraphicsUtil.getTextCursor(g, this.curText, x, y, Math.max(this.pos, this.end), halign, valign);
            g.fillRect(p.x, p.y - 1, e.x - p.x + 1, e.height + 2);
        }
        g.setColor(Color.BLACK);
        GraphicsUtil.drawText(g, this.curText, x, y, halign, valign);
        if (this.pos == this.end) {
            p = GraphicsUtil.getTextCursor(g, this.curText, x, y, this.pos, halign, valign);
            g.drawLine(p.x, p.y, p.x, p.y + p.height);
        }
    }

    @Override
    public String getText() {
        return this.curText;
    }

    @Override
    public Bounds getBounds(Graphics g) {
        int x = this.field.getX();
        int y = this.field.getY();
        int halign = this.field.getHAlign();
        int valign = this.field.getVAlign();
        Font font = this.field.getFont();
        Bounds bds = Bounds.create(GraphicsUtil.getTextBounds(g, font, this.curText, x, y, halign, valign));
        return bds.add(this.field.getBounds(g)).expand(3);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int ign = 768;
        if ((e.getModifiersEx() & 0x300) != 0) {
            return;
        }
        boolean shift = (e.getModifiersEx() & 0x40) != 0;
        boolean ctrl = (e.getModifiersEx() & 0x80) != 0;
        this.arrowKeyMaybePressed(e, shift, ctrl);
        if (e.isConsumed()) {
            return;
        }
        if (ctrl) {
            this.controlKeyPressed(e, shift);
        } else {
            this.normalKeyPressed(e, shift);
        }
    }

    protected boolean wordBoundary(int pos) {
        return pos == 0 || pos >= this.curText.length() || Character.isWhitespace(this.curText.charAt(pos - 1)) != Character.isWhitespace(this.curText.charAt(pos));
    }

    protected boolean allowedCharacter(char c) {
        return c != '\uffff' && !Character.isISOControl(c);
    }

    protected void moveCaret(int dx, int dy, boolean shift, boolean ctrl) {
        if (!shift) {
            this.normalizeSelection();
        }
        if (dy < 0) {
            this.pos = 0;
        } else if (dy > 0) {
            this.pos = this.curText.length();
        } else if (this.pos + dx >= 0 && this.pos + dx <= this.curText.length()) {
            if (!shift && this.pos != this.end) {
                if (dx < 0) {
                    this.end = this.pos;
                } else {
                    this.pos = this.end;
                }
            } else {
                this.pos += dx;
            }
            while (ctrl && !this.wordBoundary(this.pos)) {
                this.pos += dx;
            }
        }
        if (!shift) {
            this.end = this.pos;
        }
    }

    protected void controlKeyPressed(KeyEvent e, boolean shift) {
        boolean cut = false;
        switch (e.getKeyCode()) {
            case 65: {
                this.pos = 0;
                this.end = this.curText.length();
                e.consume();
                break;
            }
            case 88: 
            case 65489: {
                cut = true;
            }
            case 67: 
            case 65485: {
                if (this.end != this.pos) {
                    int pp = Math.min(this.pos, this.end);
                    int ee = Math.max(this.pos, this.end);
                    String s = this.curText.substring(pp, ee);
                    StringSelection sel = new StringSelection(s);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, null);
                    if (cut) {
                        this.normalizeSelection();
                        this.curText = this.curText.substring(0, this.pos) + (this.end < this.curText.length() ? this.curText.substring(this.end) : "");
                        this.end = this.pos;
                    }
                }
                e.consume();
                break;
            }
            case 86: 
            case 155: 
            case 65487: {
                try {
                    String s = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    boolean lastWasSpace = false;
                    for (int i = 0; i < s.length(); ++i) {
                        char c = s.charAt(i);
                        if (!this.allowedCharacter(c)) {
                            if (lastWasSpace) continue;
                            c = ' ';
                        }
                        lastWasSpace = c == ' ';
                        this.normalizeSelection();
                        this.curText = this.end < this.curText.length() ? this.curText.substring(0, this.pos) + c + this.curText.substring(this.end) : this.curText.substring(0, this.pos) + c;
                        this.end = ++this.pos;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.consume();
                break;
            }
        }
    }

    protected void arrowKeyMaybePressed(KeyEvent e, boolean shift, boolean ctrl) {
        switch (e.getKeyCode()) {
            case 37: 
            case 226: {
                this.moveCaret(-1, 0, shift, ctrl);
                e.consume();
                break;
            }
            case 39: 
            case 227: {
                this.moveCaret(1, 0, shift, ctrl);
                e.consume();
                break;
            }
            case 38: 
            case 224: {
                this.moveCaret(0, -1, shift, ctrl);
                e.consume();
                break;
            }
            case 40: 
            case 225: {
                this.moveCaret(0, 1, shift, ctrl);
                e.consume();
                break;
            }
            case 36: {
                this.pos = 0;
                if (!shift) {
                    this.end = this.pos;
                }
                e.consume();
                break;
            }
            case 35: {
                this.pos = this.curText.length();
                if (!shift) {
                    this.end = this.pos;
                }
                e.consume();
            }
        }
    }

    protected void normalKeyPressed(KeyEvent e, boolean shift) {
        switch (e.getKeyCode()) {
            case 3: 
            case 27: {
                this.cancelEditing();
                break;
            }
            case 12: {
                this.curText = "";
                this.pos = 0;
                this.end = 0;
                break;
            }
            case 10: {
                this.stopEditing();
                break;
            }
            case 8: {
                this.normalizeSelection();
                if (this.pos != this.end) {
                    this.curText = this.curText.substring(0, this.pos) + this.curText.substring(this.end);
                    this.end = this.pos;
                    break;
                }
                if (this.pos <= 0) break;
                this.curText = this.curText.substring(0, this.pos - 1) + this.curText.substring(this.pos);
                --this.pos;
                this.end = this.pos;
                break;
            }
            case 127: {
                this.normalizeSelection();
                if (this.pos != this.end) {
                    this.curText = this.curText.substring(0, this.pos) + (this.end < this.curText.length() ? this.curText.substring(this.end) : "");
                    this.end = this.pos;
                    break;
                }
                if (this.pos >= this.curText.length()) break;
                this.curText = this.curText.substring(0, this.pos) + this.curText.substring(this.pos + 1);
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        int ign = 896;
        if ((e.getModifiersEx() & 0x380) != 0) {
            return;
        }
        char c = e.getKeyChar();
        if (this.allowedCharacter(c)) {
            this.normalizeSelection();
            this.curText = this.end < this.curText.length() ? this.curText.substring(0, this.pos) + c + this.curText.substring(this.end) : this.curText.substring(0, this.pos) + c;
            ++this.pos;
            this.end = this.pos;
        } else if (c == '\n') {
            this.stopEditing();
        }
    }

    protected void normalizeSelection() {
        if (this.pos > this.end) {
            int t = this.end;
            this.end = this.pos;
            this.pos = t;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.end = this.findCaret(e.getX(), e.getY());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pos = this.end = this.findCaret(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.end = this.findCaret(e.getX(), e.getY());
    }

    protected int findCaret(int x, int y) {
        int halign = this.field.getHAlign();
        int valign = this.field.getVAlign();
        return GraphicsUtil.getTextPosition(this.g, this.curText, x -= this.field.getX(), y -= this.field.getY(), halign, valign);
    }

    @Override
    public void removeCaretListener(CaretListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void stopEditing() {
        CaretEvent e = new CaretEvent(this, this.oldText, this.curText);
        this.field.setText(this.curText);
        for (CaretListener l : new ArrayList<CaretListener>(this.listeners)) {
            l.editingStopped(e);
        }
        this.field.removeTextFieldListener(this);
    }

    @Override
    public void textChanged(TextFieldEvent e) {
        this.oldText = this.curText = this.field.getText();
        this.end = this.pos = this.curText.length();
    }
}

