/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import java.util.ArrayList;

public class WidthIncompatibilityData {
    private final ArrayList<Location> points = new ArrayList();
    private final ArrayList<BitWidth> widths = new ArrayList();

    public void add(Location p, BitWidth w) {
        for (int i = 0; i < this.points.size(); ++i) {
            if (!p.equals(this.points.get(i)) || !w.equals(this.widths.get(i))) continue;
            return;
        }
        this.points.add(p);
        this.widths.add(w);
    }

    public boolean equals(Object other) {
        if (!(other instanceof WidthIncompatibilityData)) {
            return false;
        }
        WidthIncompatibilityData o = (WidthIncompatibilityData)other;
        if (this == other) {
            return true;
        }
        if (this.size() != o.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Location p = o.getPoint(i);
            BitWidth w = o.getBitWidth(i);
            boolean matched = false;
            for (int j = 0; j < o.size(); ++j) {
                Location q = this.getPoint(j);
                BitWidth x = this.getBitWidth(j);
                if (!p.equals(q) || !w.equals(x)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public BitWidth getBitWidth(int i) {
        return this.widths.get(i);
    }

    public Location getPoint(int i) {
        return this.points.get(i);
    }

    public BitWidth getCommonBitWidth() {
        int[] hist = new int[65];
        BitWidth maxwidth = null;
        int maxcount = 0;
        for (BitWidth bw : this.widths) {
            int w;
            int n = w = bw.getWidth();
            hist[n] = hist[n] + 1;
            int n2 = hist[n];
            if (n2 > maxcount) {
                maxcount = n2;
                maxwidth = bw;
                continue;
            }
            if (n2 != maxcount) continue;
            maxwidth = null;
        }
        return maxwidth;
    }

    public int hashCode() {
        return this.size();
    }

    public int size() {
        return this.points.size();
    }
}

