/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.hex;

import com.cburch.hex.HexEditor;
import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class Test {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Model model = new Model();
        HexEditor editor = new HexEditor(model);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new JScrollPane(editor));
        frame.pack();
        frame.setVisible(true);
    }

    private static class Model
    implements HexModel {
        private final ArrayList<HexModelListener> listeners = new ArrayList();
        private final long[] data = new long[924];

        private Model() {
        }

        @Override
        public void addHexModelListener(HexModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void fill(long start, long len, long value) {
            long[] oldValues = new long[(int)len];
            System.arraycopy(this.data, (int)(start - 11111L), oldValues, 0, (int)len);
            Arrays.fill(this.data, (int)(start - 11111L), (int)len, value);
            for (HexModelListener listener : this.listeners) {
                listener.bytesChanged(this, start, len, oldValues);
            }
        }

        @Override
        public long get(long address) {
            return this.data[(int)(address - 11111L)];
        }

        @Override
        public long getFirstOffset() {
            return 11111L;
        }

        @Override
        public long getLastOffset() {
            return this.data.length + 11110;
        }

        @Override
        public int getValueWidth() {
            return 9;
        }

        @Override
        public void removeHexModelListener(HexModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void set(long address, long value) {
            long[] oldValues = new long[]{this.data[(int)(address - 11111L)]};
            this.data[(int)(address - 11111L)] = value & 0x1FFL;
            for (HexModelListener listener : this.listeners) {
                listener.bytesChanged(this, address, 1L, oldValues);
            }
        }

        @Override
        public void set(long start, long[] values) {
            long[] oldValues = new long[values.length];
            System.arraycopy(this.data, (int)(start - 11111L), oldValues, 0, values.length);
            System.arraycopy(values, 0, this.data, (int)(start - 11111L), values.length);
            for (HexModelListener listener : this.listeners) {
                listener.bytesChanged(this, start, values.length, oldValues);
            }
        }
    }
}

