/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.model;

import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.util.EventSourceWeakSupport;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractCanvasObject
implements AttributeSet,
CanvasObject,
Cloneable {
    private static final int OVERLAP_TRIES = 50;
    private static final int GENERATE_RANDOM_TRIES = 20;
    private EventSourceWeakSupport<AttributeListener> listeners = new EventSourceWeakSupport();

    @Override
    public void addAttributeListener(AttributeListener l) {
        this.listeners.add(l);
    }

    @Override
    public Handle canDeleteHandle(Location loc) {
        return null;
    }

    @Override
    public Handle canInsertHandle(Location desired) {
        return null;
    }

    @Override
    public boolean canMoveHandle(Handle handle) {
        return false;
    }

    @Override
    public boolean canRemove() {
        return true;
    }

    @Override
    public CanvasObject clone() {
        try {
            AbstractCanvasObject ret = (AbstractCanvasObject)super.clone();
            ret.listeners = new EventSourceWeakSupport();
            return ret;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean containsAttribute(Attribute<?> attr) {
        return this.getAttributes().contains(attr);
    }

    @Override
    public Handle deleteHandle(Handle handle) {
        throw new UnsupportedOperationException("deleteHandle");
    }

    protected void fireAttributeListChanged() {
        AttributeEvent e = new AttributeEvent(this);
        for (AttributeListener listener : this.listeners) {
            listener.attributeListChanged(e);
        }
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        for (Attribute<?> attr : this.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public AttributeSet getAttributeSet() {
        return this;
    }

    @Override
    public String getDisplayNameAndLabel() {
        return this.getDisplayName();
    }

    protected Location getRandomPoint(Bounds bds, Random rand) {
        int x = bds.getX();
        int y = bds.getY();
        int w = bds.getWidth();
        int h = bds.getHeight();
        for (int i = 0; i < 20; ++i) {
            Location loc = Location.create(x + rand.nextInt(w), y + rand.nextInt(h), false);
            if (!this.contains(loc, false)) continue;
            return loc;
        }
        return null;
    }

    @Override
    public void insertHandle(Handle desired, Handle previous) {
        throw new UnsupportedOperationException("insertHandle");
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return false;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave();
    }

    @Override
    public Handle moveHandle(HandleGesture gesture) {
        throw new UnsupportedOperationException("moveHandle");
    }

    @Override
    public boolean overlaps(CanvasObject other) {
        Bounds a = this.getBounds();
        Bounds b = other.getBounds();
        Bounds c = a.intersect(b);
        Random rand = new Random();
        if (c.getWidth() == 0 || c.getHeight() == 0) {
            return false;
        }
        if (other instanceof AbstractCanvasObject) {
            AbstractCanvasObject that = (AbstractCanvasObject)other;
            for (int i = 0; i < 50; ++i) {
                Location loc;
                if (!(i % 2 == 0 ? (loc = this.getRandomPoint(c, rand)) != null && that.contains(loc, false) : (loc = that.getRandomPoint(c, rand)) != null && this.contains(loc, false))) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < 50; ++i) {
            Location loc = this.getRandomPoint(c, rand);
            if (loc == null || !other.contains(loc, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAttributeListener(AttributeListener l) {
        this.listeners.remove(l);
    }

    protected boolean setForFill(Graphics g) {
        AttributeOption value;
        List<Attribute<?>> attrs = this.getAttributes();
        if (attrs.contains(DrawAttr.PAINT_TYPE) && (value = this.getValue(DrawAttr.PAINT_TYPE)) == DrawAttr.PAINT_STROKE) {
            return false;
        }
        Color color = this.getValue(DrawAttr.FILL_COLOR);
        if (color != null && color.getAlpha() == 0) {
            return false;
        }
        if (color != null) {
            g.setColor(color);
        }
        return true;
    }

    protected boolean setForStroke(Graphics g) {
        AttributeOption value;
        List<Attribute<?>> attrs = this.getAttributes();
        if (attrs.contains(DrawAttr.PAINT_TYPE) && (value = this.getValue(DrawAttr.PAINT_TYPE)) == DrawAttr.PAINT_FILL) {
            return false;
        }
        Integer width = this.getValue(DrawAttr.STROKE_WIDTH);
        if (width != null && width > 0) {
            Color color = this.getValue(DrawAttr.STROKE_COLOR);
            if (color != null && color.getAlpha() == 0) {
                return false;
            }
            GraphicsUtil.switchToWidth(g, width);
            if (color != null) {
                g.setColor(color);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setReadOnly(Attribute<?> attr, boolean value) {
        throw new UnsupportedOperationException("setReadOnly");
    }

    @Override
    public final <V> void setValue(Attribute<V> attr, V value) {
        V old = this.getValue(attr);
        boolean same = Objects.equals(old, value);
        if (!same) {
            this.updateValue(attr, value);
            AttributeEvent e = new AttributeEvent(this, attr, value, old);
            for (AttributeListener listener : this.listeners) {
                listener.attributeValueChanged(e);
            }
        }
    }

    public abstract Element toSvgElement(Document var1);

    protected abstract void updateValue(Attribute<?> var1, Object var2);
}

