/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.study;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.Objects;
import org.jabref.model.study.StudyDatabase;
import org.jabref.model.study.StudyQuery;

@JsonPropertyOrder(value={"authors", "title", "research-questions", "queries", "databases"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class Study {
    private List<String> authors;
    private String title;
    @JsonProperty(value="research-questions")
    private List<String> researchQuestions;
    private List<StudyQuery> queries;
    private List<StudyDatabase> databases;

    public Study(List<String> authors, String title, List<String> researchQuestions, List<StudyQuery> queryEntries, List<StudyDatabase> databases) {
        this.authors = authors;
        this.title = title;
        this.researchQuestions = researchQuestions;
        this.queries = queryEntries;
        this.databases = databases;
    }

    private Study() {
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public List<StudyQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<StudyQuery> queries) {
        this.queries = queries;
    }

    public List<StudyDatabase> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<StudyDatabase> databases) {
        this.databases = databases;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getResearchQuestions() {
        return this.researchQuestions;
    }

    public void setResearchQuestions(List<String> researchQuestions) {
        this.researchQuestions = researchQuestions;
    }

    public String toString() {
        return "Study{authors=" + String.valueOf(this.authors) + ", studyName='" + this.title + "', researchQuestions=" + String.valueOf(this.researchQuestions) + ", queries=" + String.valueOf(this.queries) + ", libraries=" + String.valueOf(this.databases) + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Study otherStudy = (Study)other;
        return Objects.equals(this.authors, otherStudy.authors) && Objects.equals(this.title, otherStudy.title) && Objects.equals(this.researchQuestions, otherStudy.researchQuestions) && Objects.equals(this.queries, otherStudy.queries) && Objects.equals(this.databases, otherStudy.databases);
    }

    public int hashCode() {
        return Objects.hashCode(this);
    }
}

