/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.pdf.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.jabref.model.entry.BibEntry;

public final class SearchResult {
    private final String path;
    private final int pageNumber;
    private final long modified;
    private final float luceneScore;
    private List<String> contentResultStringsHtml;
    private List<String> annotationsResultStringsHtml;

    public SearchResult(IndexSearcher searcher, Query query, ScoreDoc scoreDoc) throws IOException {
        TextFragment[] frags;
        EnglishAnalyzer analyzer;
        this.path = this.getFieldContents(searcher, scoreDoc, "path");
        this.pageNumber = Integer.parseInt(this.getFieldContents(searcher, scoreDoc, "pageNumber"));
        this.modified = Long.parseLong(this.getFieldContents(searcher, scoreDoc, "modified"));
        this.luceneScore = scoreDoc.score;
        String content = this.getFieldContents(searcher, scoreDoc, "content");
        String annotations = this.getFieldContents(searcher, scoreDoc, "annotations");
        Highlighter highlighter = new Highlighter((Formatter)new SimpleHTMLFormatter("<b>", "</b>"), (Scorer)new QueryScorer(query));
        try {
            analyzer = new EnglishAnalyzer();
            try (TokenStream contentStream = analyzer.tokenStream("content", content);){
                frags = highlighter.getBestTextFragments(contentStream, content, true, 10);
                this.contentResultStringsHtml = Arrays.stream(frags).map(TextFragment::toString).collect(Collectors.toList());
            }
            finally {
                analyzer.close();
            }
        }
        catch (InvalidTokenOffsetsException e) {
            this.contentResultStringsHtml = List.of();
        }
        try {
            analyzer = new EnglishAnalyzer();
            try (TokenStream annotationStream = analyzer.tokenStream("annotations", annotations);){
                frags = highlighter.getBestTextFragments(annotationStream, annotations, true, 10);
                this.annotationsResultStringsHtml = Arrays.stream(frags).map(TextFragment::toString).collect(Collectors.toList());
            }
            finally {
                analyzer.close();
            }
        }
        catch (InvalidTokenOffsetsException e) {
            this.annotationsResultStringsHtml = List.of();
        }
    }

    private String getFieldContents(IndexSearcher searcher, ScoreDoc scoreDoc, String field) throws IOException {
        IndexableField indexableField = searcher.storedFields().document(scoreDoc.doc).getField(field);
        if (indexableField == null) {
            return "";
        }
        return indexableField.stringValue();
    }

    public boolean isResultFor(BibEntry entry) {
        return entry.getFiles().stream().anyMatch(linkedFile -> this.path.equals(linkedFile.getLink()));
    }

    public String getPath() {
        return this.path;
    }

    public long getModified() {
        return this.modified;
    }

    public float getLuceneScore() {
        return this.luceneScore;
    }

    public List<String> getContentResultStringsHtml() {
        return this.contentResultStringsHtml;
    }

    public List<String> getAnnotationsResultStringsHtml() {
        return this.annotationsResultStringsHtml;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }
}

