/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model;

import java.util.Objects;
import java.util.Optional;

public abstract class ChainNode<T extends ChainNode<T>> {
    private T parent = null;
    private T child = null;

    public ChainNode(Class<T> derivingClass) {
        if (!derivingClass.isInstance(this)) {
            throw new UnsupportedOperationException("The class extending ChainNode<T> has to derive from T");
        }
    }

    public Optional<T> getParent() {
        return Optional.ofNullable(this.parent);
    }

    protected void setParent(T parent) {
        this.parent = (ChainNode)Objects.requireNonNull(parent);
    }

    public Optional<T> getChild() {
        return Optional.ofNullable(this.child);
    }

    public T setChild(T child) {
        Objects.requireNonNull(child);
        if (child.getParent().isPresent()) {
            throw new UnsupportedOperationException("Cannot add a node which already has a parent, use moveTo instead");
        }
        child.setParent((ChainNode)this);
        this.child = child;
        return (T)child;
    }

    public void moveTo(T target) {
        Objects.requireNonNull(target);
        if (this.isAncestorOf(target)) {
            throw new UnsupportedOperationException("the target cannot be a descendant of this node");
        }
        this.getParent().ifPresent(ChainNode::removeChild);
        target.setChild((ChainNode)this);
    }

    public void removeChild() {
        if (this.child != null) {
            ((ChainNode)this.child).setParent(null);
        }
        this.child = null;
    }

    public boolean isAncestorOf(T anotherNode) {
        Objects.requireNonNull(anotherNode);
        if (anotherNode == this) {
            return true;
        }
        return ((ChainNode)this.child).isAncestorOf(anotherNode);
    }

    public void addAtEnd(T node) {
        if (this.child == null) {
            this.setChild(node);
        } else {
            ((ChainNode)this.child).addAtEnd(node);
        }
    }
}

