/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.strings.StringLengthComparator;

public class UnitsToLatexFormatter
extends Formatter {
    private static final List<String> UNIT_LIST = Arrays.asList("A", "Ah", "B", "Bq", "C", "F", "Gy", "H", "Hz", "J", "K", "N", "\\$\\\\Omega\\$", "Pa", "S", "Sa", "Sv", "T", "V", "VA", "W", "Wb", "Wh", "bar", "b", "cd", "dB", "dBm", "dBc", "eV", "inch", "kat", "lm", "lx", "m", "mol", "rad", "s", "sr");
    private static final List<String> UNIT_PREFIX_LIST = Arrays.asList("y", "z", "a", "f", "p", "n", "\\$\\\\mu\\$", "u", "m", "c", "d", "", "da", "h", "k", "M", "G", "T", "P", "E", "Z", "Y");
    private final List<String> prefixUnitCombinations = new ArrayList<String>(UNIT_LIST.size() * UNIT_PREFIX_LIST.size());

    public UnitsToLatexFormatter() {
        for (String unit : UNIT_LIST) {
            for (String prefix : UNIT_PREFIX_LIST) {
                this.prefixUnitCombinations.add(prefix + unit);
            }
        }
        Collections.sort(this.prefixUnitCombinations, new StringLengthComparator());
    }

    @Override
    public String format(String text) {
        Objects.requireNonNull(text);
        if (text.isEmpty()) {
            return text;
        }
        String result = text.replaceAll("([0-9,\\.]+)-([Bb][Ii][Tt])", "$1\\\\mbox\\{-\\}$2");
        result = result.replaceAll("([0-9,\\.]+) ([Bb][Ii][Tt])", "$1~$2");
        for (String listOfWord : this.prefixUnitCombinations) {
            result = result.replaceAll("([0-9])(" + listOfWord + ")", "$1\\{$2\\}");
            result = result.replaceAll("([0-9])-(" + listOfWord + ")", "$1\\\\mbox\\{-\\}\\{$2\\}");
            result = result.replaceAll("([0-9]) (" + listOfWord + ")", "$1~\\{$2\\}");
        }
        return result;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Converts units to LaTeX formatting.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "1 Hz";
    }

    @Override
    public String getName() {
        return Localization.lang("Units to LaTeX", new Object[0]);
    }

    @Override
    public String getKey() {
        return "units_to_latex";
    }
}

