/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.texparser;

import java.nio.file.Path;
import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.model.strings.LatexToUnicodeAdapter;
import org.jabref.model.texparser.Citation;

public class CitationsDisplay
extends ListView<Citation> {
    private final ObjectProperty<Path> basePath = new SimpleObjectProperty(null);

    public CitationsDisplay() {
        new ViewModelListCellFactory().withGraphic(this::getDisplayGraphic).withTooltip(this::getDisplayTooltip).install(this);
        this.getStyleClass().add((Object)"citationsList");
    }

    public ObjectProperty<Path> basePathProperty() {
        return this.basePath;
    }

    private Node getDisplayGraphic(Citation item) {
        if (this.basePath.get() == null) {
            this.basePath.set((Object)item.path().getRoot());
        }
        Node citationIcon = IconTheme.JabRefIcons.LATEX_COMMENT.getGraphicNode();
        Text contextText = new Text(LatexToUnicodeAdapter.format(item.getContext()));
        contextText.wrappingWidthProperty().bind((ObservableValue)this.widthProperty().subtract(85));
        HBox contextBox = new HBox(8.0, new Node[]{citationIcon, contextText});
        contextBox.getStyleClass().add((Object)"contextBox");
        Label fileNameLabel = new Label("%s".formatted(((Path)this.basePath.get()).relativize(item.path())));
        fileNameLabel.setGraphic(IconTheme.JabRefIcons.LATEX_FILE.getGraphicNode());
        Label positionLabel = new Label("(%s:%s-%s)".formatted(item.line(), item.colStart(), item.colEnd()));
        positionLabel.setGraphic(IconTheme.JabRefIcons.LATEX_LINE.getGraphicNode());
        HBox dataBox = new HBox(5.0, new Node[]{fileNameLabel, positionLabel});
        return new VBox(new Node[]{contextBox, dataBox});
    }

    private Tooltip getDisplayTooltip(Citation item) {
        String line = item.lineText();
        int start = item.colStart();
        int end = item.colEnd();
        ArrayList<Text> texts = new ArrayList<Text>(3);
        if (start > 0) {
            texts.add(new Text(line.substring(0, start)));
        }
        Text citation = new Text(line.substring(start, end));
        citation.getStyleClass().setAll((Object[])new String[]{"tooltip-text-bold"});
        texts.add(citation);
        if (end < line.length()) {
            texts.add(new Text(line.substring(end)));
        }
        Tooltip tooltip = new Tooltip();
        tooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        tooltip.setGraphic((Node)new TextFlow((Node[])texts.toArray(new Text[0])));
        tooltip.setMaxHeight(10.0);
        tooltip.setMinWidth(200.0);
        tooltip.maxWidthProperty().bind((ObservableValue)this.widthProperty().subtract(85));
        tooltip.setWrapText(true);
        return tooltip;
    }
}

