/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;

public class OpenUrlAction
extends SimpleCommand {
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final PreferencesService preferences;

    public OpenUrlAction(DialogService dialogService, StateManager stateManager, PreferencesService preferences) {
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.preferences = preferences;
        BooleanExpression fieldIsSet = ActionHelper.isAnyFieldSetForSelectedEntry(List.of(StandardField.URL, StandardField.DOI, StandardField.URI, StandardField.EPRINT), stateManager);
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(1, stateManager).and((ObservableBooleanValue)fieldIsSet));
    }

    public void execute() {
        this.stateManager.getActiveDatabase().ifPresent(databaseContext -> {
            ObservableList<BibEntry> entries = this.stateManager.getSelectedEntries();
            if (entries.size() != 1) {
                this.dialogService.notify(Localization.lang("This operation requires exactly one item to be selected.", new Object[0]));
                return;
            }
            BibEntry entry = (BibEntry)entries.getFirst();
            Optional<String> link = entry.getField(StandardField.EPRINT);
            StandardField field = StandardField.EPRINT;
            if (entry.hasField(StandardField.URI)) {
                link = entry.getField(StandardField.URI);
                field = StandardField.URI;
            }
            if (entry.hasField(StandardField.ISBN)) {
                link = entry.getField(StandardField.ISBN);
                field = StandardField.ISBN;
            }
            if (entry.hasField(StandardField.DOI)) {
                link = entry.getField(StandardField.DOI);
                field = StandardField.DOI;
            }
            if (entry.hasField(StandardField.URL)) {
                link = entry.getField(StandardField.URL);
                field = StandardField.URL;
            }
            if (link.isPresent()) {
                try {
                    if (field.equals(StandardField.DOI) && this.preferences.getDOIPreferences().isUseCustom()) {
                        JabRefDesktop.openCustomDoi(link.get(), this.preferences, this.dialogService);
                    } else {
                        JabRefDesktop.openExternalViewer(databaseContext, this.preferences, link.get(), field, this.dialogService, entry);
                    }
                }
                catch (IOException e) {
                    this.dialogService.showErrorDialogAndWait(Localization.lang("Unable to open link.", new Object[0]), e);
                }
            }
        });
    }
}

