/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.frame;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenConsoleAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenConsoleAction.class);
    private final Supplier<BibDatabaseContext> databaseContext;
    private final StateManager stateManager;
    private final PreferencesService preferencesService;
    private final DialogService dialogService;

    public OpenConsoleAction(Supplier<BibDatabaseContext> databaseContext, StateManager stateManager, PreferencesService preferencesService, DialogService dialogService) {
        this.databaseContext = databaseContext;
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.dialogService = dialogService;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
    }

    public OpenConsoleAction(StateManager stateManager, PreferencesService preferencesService, DialogService dialogService) {
        this(() -> null, stateManager, preferencesService, dialogService);
    }

    public void execute() {
        Optional.ofNullable(this.databaseContext.get()).or(this.stateManager::getActiveDatabase).flatMap(BibDatabaseContext::getDatabasePath).ifPresent(path -> {
            try {
                JabRefDesktop.openConsole(path, this.preferencesService, this.dialogService);
            }
            catch (IOException e) {
                LOGGER.info("Could not open console", (Throwable)e);
            }
        });
    }
}

