/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors.journalinfo;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.XYChart;
import javafx.util.Pair;
import org.jabref.gui.AbstractViewModel;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.fetcher.JournalInformationFetcher;
import org.jabref.logic.journals.JournalInformation;

public class JournalInfoViewModel
extends AbstractViewModel {
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper country = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper categories = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper publisher = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper scimagoId = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper hIndex = new ReadOnlyStringWrapper();
    private final ReadOnlyStringWrapper issn = new ReadOnlyStringWrapper();
    private final ObservableList<XYChart.Series<String, Double>> sjrData = FXCollections.observableArrayList();
    private final ObservableList<XYChart.Series<String, Double>> snipData = FXCollections.observableArrayList();
    private final ObservableList<XYChart.Series<String, Double>> citableDocsPrevious3YearsData = FXCollections.observableArrayList();
    private final ObservableList<XYChart.Series<String, Double>> citesOutgoingData = FXCollections.observableArrayList();
    private final ObservableList<XYChart.Series<String, Double>> citesOutgoingPerDocData = FXCollections.observableArrayList();
    private final ObservableList<XYChart.Series<String, Double>> citesIncomingByRecentlyPublishedData = FXCollections.observableArrayList();
    private final ObservableList<XYChart.Series<String, Double>> docsThisYearData = FXCollections.observableArrayList();

    public void populateJournalInformation(String issn, String journalName) throws FetcherException {
        Optional<JournalInformation> journalInformationOptional = new JournalInformationFetcher().getJournalInformation(issn, journalName);
        journalInformationOptional.ifPresent(journalInformation -> {
            this.setTitle(journalInformation.title());
            this.setCountry(journalInformation.country());
            this.setCategories(JournalInfoViewModel.getFormattedCategories(journalInformation));
            this.setPublisher(JournalInfoViewModel.getFormattedPublisher(journalInformation));
            this.setScimagoId(journalInformation.scimagoId());
            this.sethIndex(journalInformation.hIndex());
            this.setIssn(journalInformation.issn());
            this.sjrData.add(this.convertToSeries(journalInformation.sjrArray()));
            this.snipData.add(this.convertToSeries(journalInformation.snipArray()));
            this.citableDocsPrevious3YearsData.add(this.convertToSeries(journalInformation.citableDocsPrevious3Years()));
            this.citesOutgoingData.add(this.convertToSeries(journalInformation.citesOutgoing()));
            this.citesOutgoingPerDocData.add(this.convertToSeries(journalInformation.citesOutgoingPerDoc()));
            this.citesIncomingByRecentlyPublishedData.add(this.convertToSeries(journalInformation.citesIncomingByRecentlyPublished()));
            this.docsThisYearData.add(this.convertToSeries(journalInformation.docsThisYear()));
        });
    }

    public String getTitle() {
        return this.title.get();
    }

    public ReadOnlyStringWrapper titleProperty() {
        return this.title;
    }

    private void setTitle(String title) {
        this.title.set(title);
    }

    public String getCountry() {
        return this.country.get();
    }

    public ReadOnlyStringWrapper countryProperty() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country.set(country);
    }

    public String getCategories() {
        return this.categories.get();
    }

    public ReadOnlyStringWrapper categoriesProperty() {
        return this.categories;
    }

    public void setCategories(String categories) {
        this.categories.set(categories);
    }

    public String getPublisher() {
        return this.publisher.get();
    }

    public ReadOnlyStringWrapper publisherProperty() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher.set(publisher);
    }

    public String getScimagoId() {
        return this.scimagoId.get();
    }

    public ReadOnlyStringWrapper scimagoIdProperty() {
        return this.scimagoId;
    }

    public void setScimagoId(String scimagoId) {
        this.scimagoId.set(scimagoId);
    }

    public String gethIndex() {
        return this.hIndex.get();
    }

    public ReadOnlyStringWrapper hIndexProperty() {
        return this.hIndex;
    }

    public void sethIndex(String hIndex) {
        this.hIndex.set(hIndex);
    }

    public String getIssn() {
        return this.issn.get();
    }

    public ReadOnlyStringWrapper issnProperty() {
        return this.issn;
    }

    public void setIssn(String issn) {
        this.issn.set(issn);
    }

    public ObservableList<XYChart.Series<String, Double>> getSjrData() {
        return this.sjrData;
    }

    public ObservableList<XYChart.Series<String, Double>> getSnipData() {
        return this.snipData;
    }

    public ObservableList<XYChart.Series<String, Double>> getCitableDocsPrevious3YearsData() {
        return this.citableDocsPrevious3YearsData;
    }

    public ObservableList<XYChart.Series<String, Double>> getCitesOutgoingData() {
        return this.citesOutgoingData;
    }

    public ObservableList<XYChart.Series<String, Double>> getCitesOutgoingPerDocData() {
        return this.citesOutgoingPerDocData;
    }

    public ObservableList<XYChart.Series<String, Double>> getCitesIncomingByRecentlyPublishedData() {
        return this.citesIncomingByRecentlyPublishedData;
    }

    public ObservableList<XYChart.Series<String, Double>> getDocsThisYearData() {
        return this.docsThisYearData;
    }

    public XYChart.Series<String, Double> convertToSeries(List<Pair<Integer, Double>> data) {
        XYChart.Series series = new XYChart.Series();
        data.stream().map(pair -> new XYChart.Data((Object)((Integer)pair.getKey()).toString(), (Object)((Double)pair.getValue()))).forEach(arg_0 -> series.getData().add(arg_0));
        return series;
    }

    private static String getFormattedCategories(JournalInformation journalInformation) {
        return Arrays.stream(journalInformation.categories().split(",")).map(String::trim).collect(Collectors.joining("\n"));
    }

    private static String getFormattedPublisher(JournalInformation journalInformation) {
        StringBuilder publisher = new StringBuilder();
        publisher.append(journalInformation.publisher());
        String country = journalInformation.country();
        if (!country.isBlank()) {
            publisher.append(" (").append(country).append(")");
        }
        return publisher.toString();
    }
}

