/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.externalfiles.AutoSetFileLinksUtil;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.fieldeditors.LinkedFileViewModel;
import org.jabref.gui.linkedfile.AttachFileFromURLAction;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.BindingsHelper;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.bibtex.FileFieldWriter;
import org.jabref.logic.importer.FulltextFetchers;
import org.jabref.logic.importer.util.FileFieldParser;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileNameCleaner;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.FilePreferences;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedFilesEditorViewModel
extends AbstractEditorViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkedFilesEditorViewModel.class);
    private final ListProperty<LinkedFileViewModel> files = new SimpleListProperty(FXCollections.observableArrayList(LinkedFileViewModel::getObservables));
    private final BooleanProperty fulltextLookupInProgress = new SimpleBooleanProperty(false);
    private final DialogService dialogService;
    private final BibDatabaseContext databaseContext;
    private final TaskExecutor taskExecutor;
    private final PreferencesService preferences;

    public LinkedFilesEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, DialogService dialogService, BibDatabaseContext databaseContext, TaskExecutor taskExecutor, FieldCheckers fieldCheckers, PreferencesService preferences, UndoManager undoManager) {
        super(field, suggestionProvider, fieldCheckers, undoManager);
        this.dialogService = dialogService;
        this.databaseContext = databaseContext;
        this.taskExecutor = taskExecutor;
        this.preferences = preferences;
        BindingsHelper.bindContentBidirectional(this.files, this.text, LinkedFilesEditorViewModel::getStringRepresentation, this::parseToFileViewModel);
    }

    private static String getStringRepresentation(List<LinkedFileViewModel> files) {
        List<LinkedFile> filesToSerialize = files.stream().filter(file -> !file.isAutomaticallyFound()).map(LinkedFileViewModel::getFile).collect(Collectors.toList());
        return FileFieldWriter.getStringRepresentation(filesToSerialize);
    }

    public static LinkedFile fromFile(Path file, List<Path> fileDirectories, FilePreferences filePreferences) {
        String fileExtension = FileUtil.getFileExtension(file).orElse("");
        ExternalFileType suggestedFileType = ExternalFileTypes.getExternalFileTypeByExt(fileExtension, filePreferences).orElse(new UnknownExternalFileType(fileExtension));
        Path relativePath = FileUtil.relativize(file, fileDirectories);
        return new LinkedFile("", relativePath, suggestedFileType.getName());
    }

    public LinkedFileViewModel fromFile(Path file, FilePreferences filePreferences) {
        List<Path> fileDirectories = this.databaseContext.getFileDirectories(this.preferences.getFilePreferences());
        LinkedFile linkedFile = LinkedFilesEditorViewModel.fromFile(file, fileDirectories, filePreferences);
        return new LinkedFileViewModel(linkedFile, this.entry, this.databaseContext, this.taskExecutor, this.dialogService, this.preferences);
    }

    private List<LinkedFileViewModel> parseToFileViewModel(String stringValue) {
        return FileFieldParser.parse(stringValue).stream().map(linkedFile -> new LinkedFileViewModel((LinkedFile)linkedFile, this.entry, this.databaseContext, this.taskExecutor, this.dialogService, this.preferences)).collect(Collectors.toList());
    }

    public ObservableList<LinkedFileViewModel> getFiles() {
        return (ObservableList)this.files.get();
    }

    public ListProperty<LinkedFileViewModel> filesProperty() {
        return this.files;
    }

    public void addNewFile() {
        Path workingDirectory = this.databaseContext.getFirstExistingFileDir(this.preferences.getFilePreferences()).orElse(this.preferences.getFilePreferences().getWorkingDirectory());
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().withInitialDirectory(workingDirectory).build();
        List<Path> fileDirectories = this.databaseContext.getFileDirectories(this.preferences.getFilePreferences());
        List<Path> selectedFiles = this.dialogService.showFileOpenDialogAndGetMultipleFiles(fileDialogConfiguration);
        for (Path fileToAdd : selectedFiles) {
            if (FileUtil.detectBadFileName(fileToAdd.toString())) {
                String newFilename = FileNameCleaner.cleanFileName(fileToAdd.getFileName().toString());
                boolean correctButtonPressed = this.dialogService.showConfirmationDialogAndWait(Localization.lang("File \"%0\" cannot be added!", fileToAdd.getFileName()), Localization.lang("Illegal characters in the file name detected.\nFile will be renamed to \"%0\" and added.", newFilename), Localization.lang("Rename and add", new Object[0]));
                if (!correctButtonPressed) continue;
                Path correctPath = fileToAdd.resolveSibling(newFilename);
                try {
                    Files.move(fileToAdd, correctPath, new CopyOption[0]);
                    this.addNewLinkedFile(correctPath, fileDirectories);
                }
                catch (IOException ex) {
                    LOGGER.error("Error moving file", (Throwable)ex);
                    this.dialogService.showErrorDialogAndWait(ex);
                }
                continue;
            }
            this.addNewLinkedFile(fileToAdd, fileDirectories);
        }
    }

    private void addNewLinkedFile(Path correctPath, List<Path> fileDirectories) {
        LinkedFile newLinkedFile = LinkedFilesEditorViewModel.fromFile(correctPath, fileDirectories, this.preferences.getFilePreferences());
        this.files.add((Object)new LinkedFileViewModel(newLinkedFile, this.entry, this.databaseContext, this.taskExecutor, this.dialogService, this.preferences));
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        super.bindToEntry(entry);
        if (entry != null && this.preferences.getEntryEditorPreferences().autoLinkFilesEnabled()) {
            BackgroundTask<List> findAssociatedNotLinkedFiles = BackgroundTask.wrap(() -> this.findAssociatedNotLinkedFiles(entry)).onSuccess(arg_0 -> this.files.addAll(arg_0));
            this.taskExecutor.execute(findAssociatedNotLinkedFiles);
        }
    }

    private List<LinkedFileViewModel> findAssociatedNotLinkedFiles(BibEntry entry) {
        ArrayList<LinkedFileViewModel> result = new ArrayList<LinkedFileViewModel>();
        AutoSetFileLinksUtil util = new AutoSetFileLinksUtil(this.databaseContext, this.preferences.getFilePreferences(), this.preferences.getAutoLinkPreferences());
        try {
            List<LinkedFile> linkedFiles = util.findAssociatedNotLinkedFiles(entry);
            for (LinkedFile linkedFile : linkedFiles) {
                LinkedFileViewModel newLinkedFile = new LinkedFileViewModel(linkedFile, entry, this.databaseContext, this.taskExecutor, this.dialogService, this.preferences);
                newLinkedFile.markAsAutomaticallyFound();
                result.add(newLinkedFile);
            }
        }
        catch (IOException e) {
            this.dialogService.showErrorDialogAndWait("Error accessing the file system", e);
        }
        return result;
    }

    public boolean downloadFile(String urlText) {
        try {
            URL url = new URL(urlText);
            this.addFromURLAndDownload(url);
            return true;
        }
        catch (MalformedURLException exception) {
            this.dialogService.showErrorDialogAndWait(Localization.lang("Invalid URL", new Object[0]), exception);
            return false;
        }
    }

    public void fetchFulltext() {
        FulltextFetchers fetcher = new FulltextFetchers(this.preferences.getImportFormatPreferences(), this.preferences.getImporterPreferences());
        Optional<String> urlField = this.entry.getField(StandardField.URL);
        boolean download_success = false;
        if (urlField.isPresent()) {
            download_success = this.downloadFile(urlField.get());
        }
        if (urlField.isEmpty() || !download_success) {
            BackgroundTask.wrap(() -> fetcher.findFullTextPDF(this.entry)).onRunning(() -> this.fulltextLookupInProgress.setValue(Boolean.valueOf(true))).onFinished(() -> this.fulltextLookupInProgress.setValue(Boolean.valueOf(false))).onSuccess(url -> {
                if (url.isPresent()) {
                    this.addFromURLAndDownload((URL)url.get());
                } else {
                    this.dialogService.notify(Localization.lang("No full text document found", new Object[0]));
                }
            }).executeWith(this.taskExecutor);
        }
    }

    public void addFromURL() {
        AttachFileFromURLAction.getUrlForDownloadFromClipBoardOrEntry(this.dialogService, this.entry).ifPresent(this::downloadFile);
    }

    private void addFromURLAndDownload(URL url) {
        LinkedFileViewModel onlineFile = new LinkedFileViewModel(new LinkedFile(url, ""), this.entry, this.databaseContext, this.taskExecutor, this.dialogService, this.preferences);
        this.files.add((Object)onlineFile);
        onlineFile.download(true);
    }

    public void deleteFile(LinkedFileViewModel file) {
        if (file.getFile().isOnlineLink()) {
            this.removeFileLink(file);
        } else {
            boolean deleteSuccessful = file.delete();
            if (deleteSuccessful) {
                this.files.remove((Object)file);
            }
        }
    }

    public void removeFileLink(LinkedFileViewModel file) {
        this.files.remove((Object)file);
    }

    public ReadOnlyBooleanProperty fulltextLookupInProgressProperty() {
        return this.fulltextLookupInProgress;
    }
}

