/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.fieldeditors.ContextMenuAddable;
import org.jabref.gui.fieldeditors.contextmenu.EditorContextAction;
import org.jabref.gui.keyboard.KeyBindingRepository;

public class EditorTextArea
extends TextArea
implements Initializable,
ContextMenuAddable {
    private final ContextMenu contextMenu = new ContextMenu();
    private PasteActionHandler pasteActionHandler = () -> {};

    public EditorTextArea() {
        this("");
    }

    public EditorTextArea(String text) {
        super(text);
        this.setWrapText(true);
        ClipBoardManager.addX11Support((TextInputControl)this);
    }

    @Override
    public void initContextMenu(Supplier<List<MenuItem>> items, KeyBindingRepository keyBindingRepository) {
        this.setOnContextMenuRequested(event -> {
            this.contextMenu.getItems().setAll(EditorContextAction.getDefaultContextMenuItems((TextInputControl)this));
            this.contextMenu.getItems().addAll(0, (Collection)items.get());
            this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    public void setPasteActionHandler(PasteActionHandler handler) {
        Objects.requireNonNull(handler);
        this.pasteActionHandler = handler;
    }

    public void paste() {
        super.paste();
        this.pasteActionHandler.handle();
    }

    @FunctionalInterface
    public static interface PasteActionHandler {
        public void handle();
    }
}

