/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.Future;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import kong.unirest.core.json.JSONObject;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.entryeditor.SciteTallyModel;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.DOI;
import org.jabref.preferences.PreferencesService;
import org.tinylog.Logger;

public class SciteTabViewModel
extends AbstractViewModel {
    private static final String BASE_URL = "https://api.scite.ai/";
    private final PreferencesService preferencesService;
    private final TaskExecutor taskExecutor;
    private final ObjectProperty<SciteStatus> status;
    private final StringProperty searchError;
    private Optional<SciteTallyModel> currentResult = Optional.empty();
    private Future<?> searchTask;

    public SciteTabViewModel(PreferencesService preferencesService, TaskExecutor taskExecutor) {
        this.preferencesService = preferencesService;
        this.taskExecutor = taskExecutor;
        this.status = new SimpleObjectProperty((Object)SciteStatus.IN_PROGRESS);
        this.searchError = new SimpleStringProperty("");
    }

    public boolean shouldShow() {
        return this.preferencesService.getEntryEditorPreferences().shouldShowSciteTab();
    }

    public void bindToEntry(BibEntry entry) {
        this.cancelSearch();
        if (entry == null) {
            this.searchError.set((Object)Localization.lang("No active entry", new Object[0]));
            this.status.set((Object)SciteStatus.ERROR);
            return;
        }
        if (entry.getDOI().isEmpty()) {
            this.searchError.set((Object)Localization.lang("This entry does not have a DOI", new Object[0]));
            this.status.set((Object)SciteStatus.ERROR);
            return;
        }
        this.searchTask = BackgroundTask.wrap(() -> this.fetchTallies(entry.getDOI().get())).onRunning(() -> this.status.set((Object)SciteStatus.IN_PROGRESS)).onSuccess(result -> {
            this.currentResult = Optional.of(result);
            this.status.set((Object)SciteStatus.FOUND);
        }).onFailure(error -> {
            this.searchError.set((Object)error.getMessage());
            this.status.set((Object)SciteStatus.ERROR);
        }).executeWith(this.taskExecutor);
    }

    private void cancelSearch() {
        if (this.searchTask == null || this.searchTask.isCancelled() || this.searchTask.isDone()) {
            return;
        }
        this.status.set((Object)SciteStatus.IN_PROGRESS);
        this.searchTask.cancel(true);
    }

    public SciteTallyModel fetchTallies(DOI doi) throws FetcherException {
        try {
            URL url = new URI("https://api.scite.ai/tallies/" + doi.getDOI()).toURL();
            URLDownload download = new URLDownload(url);
            String response = download.asString();
            Logger.debug((String)"Response {}", (Object[])new Object[]{response});
            JSONObject tallies = new JSONObject(response);
            if (tallies.has("detail")) {
                String message = tallies.getString("detail");
                throw new FetcherException(message);
            }
            if (!tallies.has("total")) {
                throw new FetcherException("Unexpected result data!");
            }
            return SciteTallyModel.fromJSONObject(tallies);
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new FetcherException("Malformed url for DOs", ex);
        }
        catch (IOException ioex) {
            throw new FetcherException("Failed to retrieve tallies for DOI - IO Exception", ioex);
        }
    }

    public ObjectProperty<SciteStatus> statusProperty() {
        return this.status;
    }

    public StringProperty searchErrorProperty() {
        return this.searchError;
    }

    public Optional<SciteTallyModel> getCurrentResult() {
        return this.currentResult;
    }

    public static enum SciteStatus {
        IN_PROGRESS,
        FOUND,
        ERROR;

    }
}

