/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit;

import java.util.Optional;
import javafx.scene.control.TextArea;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.identifier.DOI;

public class CopyDoiUrlAction
extends SimpleCommand {
    private final TextArea component;
    private final StandardActions action;
    private final DialogService dialogService;
    private final ClipBoardManager clipBoardManager;

    public CopyDoiUrlAction(TextArea component, StandardActions action, DialogService dialogService, ClipBoardManager clipBoardManager) {
        this.component = component;
        this.action = action;
        this.dialogService = dialogService;
        this.clipBoardManager = clipBoardManager;
    }

    public void execute() {
        String identifier = this.component.getText();
        if (this.action == StandardActions.COPY_DOI_URL) {
            this.copy(DOI.parse(identifier).map(DOI::getURIAsASCIIString), identifier);
        } else {
            this.copy(DOI.parse(identifier).map(DOI::getDOI), identifier);
        }
    }

    private void copy(Optional<String> urlOptional, String identifier) {
        if (urlOptional.isPresent()) {
            this.clipBoardManager.setContent(urlOptional.get());
            this.dialogService.notify(Localization.lang("The link has been copied to the clipboard.", new Object[0]));
        } else {
            this.dialogService.notify(Localization.lang("Invalid DOI: '%0'.", identifier));
        }
    }
}

