/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.cleanup;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.cleanup.CleanupDialog;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.cleanup.CleanupWorker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.FieldChange;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.CleanupPreferences;
import org.jabref.preferences.PreferencesService;

public class CleanupAction
extends SimpleCommand {
    private final Supplier<LibraryTab> tabSupplier;
    private final PreferencesService preferences;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final TaskExecutor taskExecutor;
    private final UndoManager undoManager;
    private boolean isCanceled;
    private int modifiedEntriesCount;

    public CleanupAction(Supplier<LibraryTab> tabSupplier, PreferencesService preferences, DialogService dialogService, StateManager stateManager, TaskExecutor taskExecutor, UndoManager undoManager) {
        this.tabSupplier = tabSupplier;
        this.preferences = preferences;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.taskExecutor = taskExecutor;
        this.undoManager = undoManager;
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        if (this.stateManager.getActiveDatabase().isEmpty()) {
            return;
        }
        if (this.stateManager.getSelectedEntries().isEmpty()) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Cleanup entry", new Object[0]), Localization.lang("First select entries to clean up.", new Object[0]));
            return;
        }
        this.isCanceled = false;
        this.modifiedEntriesCount = 0;
        CleanupDialog cleanupDialog = new CleanupDialog(this.stateManager.getActiveDatabase().get(), this.preferences.getCleanupPreferences(), this.preferences.getFilePreferences());
        Optional<CleanupPreferences> chosenPreset = this.dialogService.showCustomDialogAndWait(cleanupDialog);
        chosenPreset.ifPresent(preset -> {
            boolean confirmed;
            if (preset.isActive(CleanupPreferences.CleanupStep.RENAME_PDF).booleanValue() && this.preferences.getAutoLinkPreferences().shouldAskAutoNamingPdfs() && !(confirmed = this.dialogService.showConfirmationDialogWithOptOutAndWait(Localization.lang("Autogenerate PDF Names", new Object[0]), Localization.lang("Auto-generating PDF-Names does not support undo. Continue?", new Object[0]), Localization.lang("Autogenerate PDF Names", new Object[0]), Localization.lang("Cancel", new Object[0]), Localization.lang("Do not ask again", new Object[0]), optOut -> this.preferences.getAutoLinkPreferences().setAskAutoNamingPdfs(optOut == false)))) {
                this.isCanceled = true;
                return;
            }
            this.preferences.getCleanupPreferences().setActiveJobs(preset.getActiveJobs());
            this.preferences.getCleanupPreferences().setFieldFormatterCleanups(preset.getFieldFormatterCleanups());
            BackgroundTask.wrap(() -> this.cleanup(this.stateManager.getActiveDatabase().get(), (CleanupPreferences)preset)).onSuccess(result -> this.showResults()).onFailure(this.dialogService::showErrorDialogAndWait).executeWith(this.taskExecutor);
        });
    }

    private void doCleanup(BibDatabaseContext databaseContext, CleanupPreferences preset, BibEntry entry, NamedCompound ce) {
        CleanupWorker cleaner = new CleanupWorker(databaseContext, this.preferences.getFilePreferences(), this.preferences.getTimestampPreferences());
        List<FieldChange> changes = cleaner.cleanup(preset, entry);
        for (FieldChange change : changes) {
            ce.addEdit(new UndoableFieldChange(change));
        }
    }

    private void showResults() {
        if (this.isCanceled) {
            return;
        }
        if (this.modifiedEntriesCount > 0) {
            this.tabSupplier.get().updateEntryEditorIfShowing();
            this.tabSupplier.get().markBaseChanged();
        }
        if (this.modifiedEntriesCount == 0) {
            this.dialogService.notify(Localization.lang("No entry needed a clean up", new Object[0]));
        } else if (this.modifiedEntriesCount == 1) {
            this.dialogService.notify(Localization.lang("One entry needed a clean up", new Object[0]));
        } else {
            this.dialogService.notify(Localization.lang("%0 entries needed a clean up", Integer.toString(this.modifiedEntriesCount)));
        }
    }

    private void cleanup(BibDatabaseContext databaseContext, CleanupPreferences cleanupPreferences) {
        for (BibEntry entry : this.stateManager.getSelectedEntries()) {
            NamedCompound ce = new NamedCompound(Localization.lang("Cleanup entry", new Object[0]));
            this.doCleanup(databaseContext, cleanupPreferences, entry, ce);
            ce.end();
            if (!ce.hasEdits()) continue;
            ++this.modifiedEntriesCount;
            this.undoManager.addEdit(ce);
        }
    }
}

