/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import com.airhacks.afterburner.injection.Injector;
import com.sun.javafx.scene.control.ContextMenuContent;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import org.controlsfx.control.action.ActionUtils;
import org.jabref.gui.actions.Action;
import org.jabref.gui.actions.JabRefAction;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionFactory.class);
    private final KeyBindingRepository keyBindingRepository = (KeyBindingRepository)Injector.instantiateModelOrService(KeyBindingRepository.class);

    private static void setGraphic(MenuItem node, Action action) {
        node.graphicProperty().unbind();
        action.getIcon().ifPresent(icon -> node.setGraphic(icon.getGraphicNode()));
    }

    private static Label getAssociatedNode(MenuItem menuItem) {
        ContextMenuContent.MenuItemContainer container = (ContextMenuContent.MenuItemContainer)menuItem.getStyleableNode();
        if (container == null) {
            return null;
        }
        try {
            Method getLabel = ContextMenuContent.MenuItemContainer.class.getDeclaredMethod("getLabel", new Class[0]);
            getLabel.setAccessible(true);
            return (Label)getLabel.invoke((Object)container, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InaccessibleObjectException | InvocationTargetException e) {
            LOGGER.warn("Could not get label of menu item", (Throwable)e);
            return null;
        }
    }

    public MenuItem configureMenuItem(Action action, Command command, MenuItem menuItem) {
        ActionUtils.configureMenuItem((org.controlsfx.control.action.Action)new JabRefAction(action, command, this.keyBindingRepository), (MenuItem)menuItem);
        ActionFactory.setGraphic(menuItem, action);
        ActionFactory.enableTooltips(command, menuItem);
        return menuItem;
    }

    private static void enableTooltips(Command command, MenuItem menuItem) {
        if (command instanceof SimpleCommand) {
            SimpleCommand simpleCommand = (SimpleCommand)command;
            EasyBind.subscribe((ObservableValue)simpleCommand.statusMessageProperty(), message -> {
                Label label = ActionFactory.getAssociatedNode(menuItem);
                if (label != null) {
                    label.setMouseTransparent(false);
                    if (StringUtil.isBlank(message)) {
                        label.setTooltip(null);
                    } else {
                        label.setTooltip(new Tooltip(message));
                    }
                }
            });
        }
    }

    public MenuItem createMenuItem(Action action, Command command) {
        MenuItem menuItem = new MenuItem();
        this.configureMenuItem(action, command, menuItem);
        return menuItem;
    }

    public CheckMenuItem createCheckMenuItem(Action action, Command command, boolean selected) {
        CheckMenuItem checkMenuItem = ActionUtils.createCheckMenuItem((org.controlsfx.control.action.Action)new JabRefAction(action, command, this.keyBindingRepository));
        checkMenuItem.setSelected(selected);
        ActionFactory.setGraphic((MenuItem)checkMenuItem, action);
        return checkMenuItem;
    }

    public CheckMenuItem createCheckMenuItem(Action action, Command command, BooleanExpression selectedBinding) {
        CheckMenuItem checkMenuItem = ActionUtils.createCheckMenuItem((org.controlsfx.control.action.Action)new JabRefAction(action, command, this.keyBindingRepository));
        EasyBind.subscribe((ObservableValue)selectedBinding, arg_0 -> ((CheckMenuItem)checkMenuItem).setSelected(arg_0));
        ActionFactory.setGraphic((MenuItem)checkMenuItem, action);
        return checkMenuItem;
    }

    public Menu createMenu(Action action) {
        Menu menu = ActionUtils.createMenu((org.controlsfx.control.action.Action)new JabRefAction(action, this.keyBindingRepository));
        ActionFactory.setGraphic((MenuItem)menu, action);
        return menu;
    }

    public Menu createSubMenu(Action action, MenuItem ... children) {
        Menu menu = this.createMenu(action);
        menu.getItems().addAll((Object[])children);
        return menu;
    }

    public Button createIconButton(Action action, Command command) {
        Button button = ActionUtils.createButton((org.controlsfx.control.action.Action)new JabRefAction(action, command, this.keyBindingRepository), (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        button.getStyleClass().setAll((Object[])new String[]{"icon-button"});
        button.graphicProperty().unbind();
        action.getIcon().ifPresent(icon -> button.setGraphic(icon.getGraphicNode()));
        button.setFocusTraversable(false);
        return button;
    }

    public ButtonBase configureIconButton(Action action, Command command, ButtonBase button) {
        ActionUtils.unconfigureButton((ButtonBase)button);
        ActionUtils.configureButton((org.controlsfx.control.action.Action)new JabRefAction(action, command, this.keyBindingRepository), (ButtonBase)button, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        button.getStyleClass().add((Object)"icon-button");
        button.graphicProperty().unbind();
        action.getIcon().ifPresent(icon -> button.setGraphic(icon.getGraphicNode()));
        return button;
    }
}

