/*
 * Decompiled with CFR 0.152.
 */
package org.jabref;

import com.airhacks.afterburner.injection.Injector;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.cli.ParseException;
import org.jabref.cli.ArgumentProcessor;
import org.jabref.cli.JabRefCLI;
import org.jabref.gui.JabRefGUI;
import org.jabref.gui.util.DefaultDirectoryMonitor;
import org.jabref.gui.util.DefaultFileUpdateMonitor;
import org.jabref.logic.UiCommand;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.net.ProxyAuthenticator;
import org.jabref.logic.net.ProxyPreferences;
import org.jabref.logic.net.ProxyRegisterer;
import org.jabref.logic.net.ssl.SSLPreferences;
import org.jabref.logic.net.ssl.TrustStoreManager;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.remote.client.RemoteClient;
import org.jabref.logic.util.BuildInfo;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.logic.util.OS;
import org.jabref.migrations.PreferencesMigrations;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.DirectoryMonitor;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.JabRefPreferences;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.tinylog.configuration.Configuration;

public class Launcher {
    private static Logger LOGGER;

    public static void main(String[] args) {
        Launcher.initLogging(args);
        try {
            Injector.setModelOrService(BuildInfo.class, (Object)new BuildInfo());
            JabRefPreferences preferences = JabRefPreferences.getInstance();
            Injector.setModelOrService(PreferencesService.class, (Object)preferences);
            if (!Launcher.handleMultipleAppInstances(args, preferences.getRemotePreferences())) {
                return;
            }
            BibEntryTypesManager entryTypesManager = preferences.getCustomEntryTypesRepository();
            Injector.setModelOrService(BibEntryTypesManager.class, (Object)entryTypesManager);
            PreferencesMigrations.runMigrations(preferences, entryTypesManager);
            Injector.setModelOrService(JournalAbbreviationRepository.class, (Object)JournalAbbreviationLoader.loadRepository(preferences.getJournalAbbreviationPreferences()));
            Injector.setModelOrService(ProtectedTermsLoader.class, (Object)new ProtectedTermsLoader(preferences.getProtectedTermsPreferences()));
            Launcher.configureProxy(preferences.getProxyPreferences());
            Launcher.configureSSL(preferences.getSSLPreferences());
            Launcher.clearOldSearchIndices();
            try {
                DefaultFileUpdateMonitor fileUpdateMonitor = new DefaultFileUpdateMonitor();
                Injector.setModelOrService(FileUpdateMonitor.class, (Object)fileUpdateMonitor);
                HeadlessExecutorService.INSTANCE.executeInterruptableTask(fileUpdateMonitor, "FileUpdateMonitor");
                DefaultDirectoryMonitor directoryMonitor = new DefaultDirectoryMonitor();
                Injector.setModelOrService(DirectoryMonitor.class, (Object)directoryMonitor);
                ArgumentProcessor argumentProcessor = new ArgumentProcessor(args, ArgumentProcessor.Mode.INITIAL_START, preferences, fileUpdateMonitor, entryTypesManager);
                argumentProcessor.processArguments();
                if (argumentProcessor.shouldShutDown()) {
                    LOGGER.debug("JabRef shut down after processing command line arguments");
                    System.exit(0);
                }
                ArrayList<UiCommand> uiCommands = new ArrayList<UiCommand>(argumentProcessor.getUiCommands());
                JabRefGUI.setup(uiCommands, preferences, fileUpdateMonitor);
                JabRefGUI.launch(JabRefGUI.class, (String[])args);
            }
            catch (ParseException e) {
                LOGGER.error("Problem parsing arguments", (Throwable)e);
                JabRefCLI.printUsage(preferences);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unexpected exception", (Throwable)ex);
        }
    }

    private static void initLogging(String[] args) {
        boolean isDebugEnabled;
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        try {
            JabRefCLI jabRefCLI = new JabRefCLI(args);
            isDebugEnabled = jabRefCLI.isDebugLogging();
        }
        catch (ParseException e) {
            isDebugEnabled = false;
        }
        Path directory = OS.getNativeDesktop().getLogDirectory();
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER = LoggerFactory.getLogger(Launcher.class);
            LOGGER.error("Could not create log directory {}", (Object)directory, (Object)e);
            return;
        }
        Map<String, String> configuration = Map.of("level", isDebugEnabled ? "debug" : "info", "writerFile", "rolling file", "writerFile.level", isDebugEnabled ? "debug" : "info", "writerFile.file", String.valueOf(directory) + File.separator + "log_{date:yyyy-MM-dd_HH-mm-ss}.txt", "writerFile.charset", "UTF-8", "writerFile.policies", "startup", "writerFile.backups", "30");
        configuration.forEach(Configuration::set);
        LOGGER = LoggerFactory.getLogger(Launcher.class);
    }

    private static boolean handleMultipleAppInstances(String[] args, RemotePreferences remotePreferences) {
        LOGGER.trace("Checking for remote handling...");
        if (remotePreferences.useRemoteServer()) {
            RemoteClient remoteClient = new RemoteClient(remotePreferences.getPort());
            if (remoteClient.ping()) {
                LOGGER.debug("Pinging other instance succeeded.");
                LOGGER.debug("Passing arguments passed on to running JabRef...");
                if (remoteClient.sendCommandLineArguments(args)) {
                    LOGGER.info("Arguments passed on to running JabRef instance. Shutting down.");
                    return false;
                }
                LOGGER.warn("Could not communicate with other running JabRef instance.");
                return false;
            }
            LOGGER.debug("Could not ping JabRef instance.");
        }
        return true;
    }

    private static void configureProxy(ProxyPreferences proxyPreferences) {
        ProxyRegisterer.register(proxyPreferences);
        if (proxyPreferences.shouldUseProxy() && proxyPreferences.shouldUseAuthentication()) {
            Authenticator.setDefault(new ProxyAuthenticator());
        }
    }

    private static void configureSSL(SSLPreferences sslPreferences) {
        TrustStoreManager.createTruststoreFileIfNotExist(Path.of(sslPreferences.getTruststorePath(), new String[0]));
    }

    private static void clearOldSearchIndices() {
        Path currentIndexPath = OS.getNativeDesktop().getFulltextIndexBaseDirectory();
        Path appData = currentIndexPath.getParent();
        try {
            Files.createDirectories(currentIndexPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not create index directory {}", (Object)appData, (Object)e);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(appData);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0]) || path.toString().endsWith("ssl") || !path.toString().contains("lucene") || path.equals(currentIndexPath)) continue;
                LOGGER.info("Deleting out-of-date fulltext search index at {}.", (Object)path);
                Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not access app-directory at {}", (Object)appData, (Object)e);
        }
    }
}

