/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.value;

import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.reactfx.value.SimpleVar;
import org.reactfx.value.SuspendableVar;
import org.reactfx.value.SuspendableVarWrapper;
import org.reactfx.value.Val;
import org.reactfx.value.VarWrapper;

public interface Var<T>
extends Val<T>,
Property<T> {
    public static <T> Var<T> newSimpleVar(T initialValue) {
        return new SimpleVar<T>(initialValue);
    }

    public static <T> Var<T> fromVal(ObservableValue<T> obs, Consumer<T> setValue) {
        if (obs instanceof Val) {
            return ((Val)obs).asVar(setValue);
        }
        return Val.wrap(obs).asVar(setValue);
    }

    public static Var<Double> doubleVar(DoubleProperty p) {
        return Var.mapBidirectional(p, Number::doubleValue, Function.identity());
    }

    public static Var<Float> floatVar(FloatProperty p) {
        return Var.mapBidirectional(p, Number::floatValue, Function.identity());
    }

    public static Var<Integer> integerVar(IntegerProperty p) {
        return Var.mapBidirectional(p, Number::intValue, Function.identity());
    }

    public static Var<Long> longVar(LongProperty p) {
        return Var.mapBidirectional(p, Number::longValue, Function.identity());
    }

    public static <T, U> Var<U> mapBidirectional(Property<T> src, Function<? super T, ? extends U> f, Function<? super U, ? extends T> g) {
        return Val.map(src, f).asVar(u -> src.setValue(g.apply((Object)u)));
    }

    public static <T> SuspendableVar<T> suspendable(Property<T> p) {
        if (p instanceof SuspendableVar) {
            return (SuspendableVar)p;
        }
        Var<T> var = p instanceof Var ? (Var<T>)p : new VarWrapper<T>(p);
        return new SuspendableVarWrapper(var);
    }

    default public void bindBidirectional(Property<T> other) {
        Bindings.bindBidirectional((Property)this, other);
    }

    default public void unbindBidirectional(Property<T> other) {
        Bindings.unbindBidirectional((Property)this, other);
    }

    default public Object getBean() {
        return null;
    }

    default public String getName() {
        return null;
    }

    @Override
    default public SuspendableVar<T> suspendable() {
        return Var.suspendable(this);
    }

    default public <U> Var<U> mapBidirectional(Function<? super T, ? extends U> f, Function<? super U, ? extends T> g) {
        return Var.mapBidirectional(this, f, g);
    }
}

