/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import org.apache.commons.lang3.StringUtils;

public class EnumUtil {
    private EnumUtil() {
    }

    public static <T extends Enum<T>> String formatEnumNameAsCapitalized(T enumValue) {
        return EnumUtil.formatEnumNameAsCapitalized(enumValue, "");
    }

    public static <T extends Enum<T>> String formatEnumNameAsCapitalized(T enumValue, String nullDefaultValue) {
        return enumValue == null ? nullDefaultValue : EnumUtil.formatEnumNameAsCapitalized(enumValue.name());
    }

    public static <T extends Enum<T>> String formatEnumNameAsCapitalized(String enumName) {
        return enumName == null ? "" : StringUtils.capitalize((String)enumName.replace("_", " ").toLowerCase());
    }

    public static <T extends Enum<T>> String formatEnumNameAsTitleCase(T enumValue) {
        return EnumUtil.formatEnumNameAsTitleCase(enumValue, "");
    }

    public static <T extends Enum<T>> String formatEnumNameAsTitleCase(T enumValue, String nullDefaultValue) {
        return EnumUtil.formatEnumNameAsTitleCase(enumValue == null ? null : enumValue.name(), nullDefaultValue);
    }

    public static <T extends Enum<T>> String formatEnumNameAsTitleCase(String enumName) {
        return EnumUtil.formatEnumNameAsTitleCase(enumName, "");
    }

    public static <T extends Enum<T>> String formatEnumNameAsTitleCase(String enumName, String nullDefaultValue) {
        if (enumName == null) {
            return nullDefaultValue;
        }
        String lowerCased = enumName.replace("_", " ").toLowerCase();
        String[] words = StringUtils.split((String)lowerCased);
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (!result.isEmpty()) {
                result.append(" ");
            }
            result.append(StringUtils.capitalize((String)word));
        }
        return result.toString();
    }

    public static <T extends Enum<T>> String formatEnumNameAsSpacedWords(T enumValue) {
        return enumValue == null ? "" : enumValue.name().replace("_", " ");
    }

    public static <T extends Enum<T>> String formatEnumNameAsSpacedWords(String enumName) {
        return enumName == null ? "" : enumName.replace("_", " ");
    }

    public static <T extends Enum<T>> String convertToStyleClassName(T enumValue) {
        return enumValue.name().toLowerCase().replace("_", "-");
    }

    public static <T extends Enum<T>> String[] convertAllToStylesClassName(Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        return EnumUtil.convertAllToStylesClassName((Enum[])enumConstants);
    }

    public static <T extends Enum<T>> String[] convertAllToStylesClassName(T[] enumValues) {
        String[] styles = new String[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            styles[i] = EnumUtil.convertToStyleClassName(enumValues[i]);
        }
        return styles;
    }
}

