/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.CustomComboBox;
import com.dlsc.gemsfx.YearPicker;
import com.dlsc.gemsfx.YearView;
import com.dlsc.gemsfx.skins.ToggleVisibilityComboBoxSkin;
import java.util.Objects;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.kordamp.ikonli.javafx.FontIcon;

public class YearPickerSkin
extends ToggleVisibilityComboBoxSkin<YearPicker> {
    private final HBox box;
    private final TextField editor;
    private final StackPane editButton;
    private YearView yearView;

    public YearPickerSkin(YearPicker picker) {
        super(picker);
        FontIcon calendarIcon = new FontIcon();
        calendarIcon.getStyleClass().add((Object)"edit-icon");
        this.editButton = new StackPane(new Node[]{calendarIcon});
        this.editButton.setFocusTraversable(false);
        this.editButton.setMaxWidth(Double.MAX_VALUE);
        this.editButton.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.editButton.getStyleClass().add((Object)"edit-button");
        this.editButton.addEventFilter(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        this.editButton.addEventFilter(MouseEvent.MOUSE_ENTERED, this::mouseEntered);
        this.editButton.addEventFilter(MouseEvent.MOUSE_EXITED, this::mouseExited);
        this.editor = picker.getEditor();
        HBox.setHgrow((Node)this.editor, (Priority)Priority.ALWAYS);
        this.box = new HBox();
        this.box.getStyleClass().add((Object)"box");
        this.updateBox();
        this.getChildren().add((Object)this.box);
        this.registerChangeListener((ObservableValue)picker.buttonDisplayProperty(), it -> this.updateBox());
    }

    private void updateBox() {
        CustomComboBox.ButtonDisplay buttonDisplay = ((YearPicker)this.getSkinnable()).getButtonDisplay();
        switch (buttonDisplay) {
            case LEFT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editButton, this.editor});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
                break;
            }
            case RIGHT: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editor, this.editButton});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
                break;
            }
            case BUTTON_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editButton});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.ALWAYS);
                break;
            }
            case FIELD_ONLY: {
                this.box.getChildren().setAll((Object[])new Node[]{this.editor});
                HBox.setHgrow((Node)this.editButton, (Priority)Priority.NEVER);
            }
        }
    }

    @Override
    protected Node getPopupContent() {
        if (this.yearView == null) {
            this.yearView = ((YearPicker)this.getSkinnable()).getYearView();
            this.yearView.valueProperty().bindBidirectional((Property)((YearPicker)this.getSkinnable()).valueProperty());
            this.yearView.valueProperty().addListener((obs, oldValue, newValue) -> {
                if (!Objects.equals(oldValue, newValue)) {
                    ((YearPicker)this.getSkinnable()).hide();
                }
            });
        }
        return this.yearView;
    }
}

